/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateException;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultResolveNaturalIdEventListener
extends AbstractLockUpgradeEventListener
implements ResolveNaturalIdEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultResolveNaturalIdEventListener.class);

    @Override
    public void onResolveNaturalId(ResolveNaturalIdEvent event) throws HibernateException {
        event.setEntityId(this.resolveNaturalId(event));
    }

    protected Object resolveNaturalId(ResolveNaturalIdEvent event) {
        Object entityId;
        EntityPersister persister = event.getEntityPersister();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Attempting to resolve: {0}#{1}", MessageHelper.infoString(persister), event.getNaturalIdValues());
        }
        if ((entityId = this.resolveFromCache(event)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Resolved object in cache: {0}#{1}", MessageHelper.infoString(persister), event.getNaturalIdValues());
            }
            return entityId;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Object not resolved in any cache: {0}#{1}", MessageHelper.infoString(persister), event.getNaturalIdValues());
        }
        return this.loadFromDatasource(event);
    }

    protected Object resolveFromCache(ResolveNaturalIdEvent event) {
        return event.getSession().getPersistenceContextInternal().getNaturalIdResolutions().findCachedIdByNaturalId(event.getOrderedNaturalIdValues(), event.getEntityPersister());
    }

    protected Object loadFromDatasource(ResolveNaturalIdEvent event) {
        EventSource session = event.getSession();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean statisticsEnabled = statistics.isStatisticsEnabled();
        long startTime = 0L;
        if (statisticsEnabled) {
            startTime = System.nanoTime();
        }
        Object pk = event.getEntityPersister().loadEntityIdByNaturalId(event.getOrderedNaturalIdValues(), event.getLockOptions(), session);
        if (statisticsEnabled) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.naturalIdQueryExecuted(event.getEntityPersister().getRootEntityName(), milliseconds);
        }
        if (pk != null) {
            session.getPersistenceContextInternal().getNaturalIdResolutions().cacheResolutionFromLoad(pk, event.getOrderedNaturalIdValues(), event.getEntityPersister());
        }
        return pk;
    }
}

