/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.function.Function;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.ReactiveAuthenticationUtils;
import org.springframework.security.authorization.method.ReactiveMethodInvocationUtils;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AuthorizationManagerAfterReactiveMethodInterceptor
implements Ordered,
MethodInterceptor,
PointcutAdvisor,
AopInfrastructureBean {
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private static final int RETURN_TYPE_METHOD_PARAMETER_INDEX = -1;
    private final Pointcut pointcut;
    private final ReactiveAuthorizationManager<MethodInvocationResult> authorizationManager;
    private int order = AuthorizationInterceptorsOrder.LAST.getOrder();

    public static AuthorizationManagerAfterReactiveMethodInterceptor postAuthorize() {
        return AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize(new PostAuthorizeReactiveAuthorizationManager());
    }

    public static AuthorizationManagerAfterReactiveMethodInterceptor postAuthorize(ReactiveAuthorizationManager<MethodInvocationResult> authorizationManager) {
        AuthorizationManagerAfterReactiveMethodInterceptor interceptor = new AuthorizationManagerAfterReactiveMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PostAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.POST_AUTHORIZE.getOrder());
        return interceptor;
    }

    public AuthorizationManagerAfterReactiveMethodInterceptor(Pointcut pointcut, ReactiveAuthorizationManager<MethodInvocationResult> authorizationManager) {
        Assert.notNull((Object)pointcut, (String)"pointcut cannot be null");
        Assert.notNull(authorizationManager, (String)"authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        Class<?> type = method.getReturnType();
        boolean isSuspendingFunction = KotlinDetector.isSuspendingFunction((Method)method);
        boolean hasFlowReturnType = COROUTINES_FLOW_CLASS_NAME.equals(new MethodParameter(method, -1).getParameterType().getName());
        boolean hasReactiveReturnType = Publisher.class.isAssignableFrom(type) || isSuspendingFunction || hasFlowReturnType;
        Assert.state((boolean)hasReactiveReturnType, () -> "The returnType " + type + " on " + method + " must return an instance of org.reactivestreams.Publisher (for example, a Mono or Flux) or the function must be a Kotlin coroutine in order to support Reactor Context");
        Mono<Authentication> authentication = ReactiveAuthenticationUtils.getAuthentication();
        Function<Object, Mono> postAuthorize = result -> this.postAuthorize(authentication, mi, result);
        ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(type);
        if (hasFlowReturnType) {
            if (isSuspendingFunction) {
                Publisher publisher = (Publisher)ReactiveMethodInvocationUtils.proceed(mi);
                return Flux.from((Publisher)publisher).flatMap(postAuthorize);
            }
            Assert.state((adapter != null ? 1 : 0) != 0, () -> "The returnType " + type + " on " + method + " must have a org.springframework.core.ReactiveAdapter registered");
            Flux response = Flux.defer(() -> adapter.toPublisher(ReactiveMethodInvocationUtils.proceed(mi))).flatMap(postAuthorize);
            return KotlinDelegate.asFlow(response);
        }
        Publisher publisher = (Publisher)ReactiveMethodInvocationUtils.proceed(mi);
        if (this.isMultiValue(type, adapter)) {
            Flux flux = Flux.from((Publisher)publisher).flatMap(postAuthorize);
            return adapter != null ? adapter.fromPublisher((Publisher)flux) : flux;
        }
        Mono mono = Mono.from((Publisher)publisher).flatMap(postAuthorize);
        return adapter != null ? adapter.fromPublisher((Publisher)mono) : mono;
    }

    private boolean isMultiValue(Class<?> returnType, ReactiveAdapter adapter) {
        if (Flux.class.isAssignableFrom(returnType)) {
            return true;
        }
        return adapter != null && adapter.isMultiValue();
    }

    private Mono<?> postAuthorize(Mono<Authentication> authentication, MethodInvocation mi, Object result) {
        return this.authorizationManager.verify(authentication, new MethodInvocationResult(mi, result)).thenReturn(result);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return true;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        private static Object asFlow(Publisher<?> publisher) {
            return ReactiveFlowKt.asFlow(publisher);
        }
    }
}

