/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.Sync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Semaphore
implements Sync {
    private static final Logger logger = LoggerFactory.getLogger(Semaphore.class);
    protected long permits_;

    public Semaphore(long initialPermits) {
        this.permits_ = initialPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() throws InterruptedException {
        logger.debug("acquire() - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.permits_ <= 0L) {
                    this.wait();
                }
                --this.permits_;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    @Override
    public boolean attempt(long msecs) throws InterruptedException {
        logger.debug("attempt(msecs={}) - start", (Object)String.valueOf(msecs));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.permits_ > 0L) {
                --this.permits_;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            try {
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this.permits_ <= 0L) continue;
                    --this.permits_;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    @Override
    public synchronized void release() {
        logger.debug("release() - start");
        ++this.permits_;
        this.notify();
    }

    public synchronized void release(long n) {
        logger.debug("release(n={}) - start", (Object)String.valueOf(n));
        if (n < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permits_ += n;
        for (long i = 0L; i < n; ++i) {
            this.notify();
        }
    }

    public synchronized long permits() {
        return this.permits_;
    }
}

