/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.List;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerFormatEmulation
extends FormatFunction {
    public SQLServerFormatEmulation(TypeConfiguration typeConfiguration) {
        super("format", typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        Expression datetime = (Expression)arguments.get(0);
        sqlAppender.appendSql("format(");
        if (this.needsDateTimeCast(datetime)) {
            sqlAppender.appendSql("cast(");
            datetime.accept(walker);
            sqlAppender.appendSql(" as datetime)");
        } else {
            datetime.accept(walker);
        }
        sqlAppender.appendSql(',');
        arguments.get(1).accept(walker);
        sqlAppender.appendSql(')');
    }

    private boolean needsDateTimeCast(Expression datetime) {
        boolean isTime;
        boolean bl = isTime = TypeConfiguration.getSqlTemporalType(datetime.getExpressionType()) == TemporalType.TIME;
        if (isTime) {
            return datetime.getExpressionType().getSingleJdbcMapping().getJdbcType().getDefaultSqlTypeCode() != 2013;
        }
        return false;
    }
}

