/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.task.status.util;

import ai.digital.deploy.tasker.common.TaskType;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.SearchParameters;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class DeploymentStatusUtils$ {
    public static final DeploymentStatusUtils$ MODULE$ = new DeploymentStatusUtils$();
    private static final String explorerPath = "/#/explorer";

    public String explorerPath() {
        return explorerPath;
    }

    public String extractMetadata(String field, SerializableTask task) {
        return (String)Option$.MODULE$.apply(task.getMetadata().get(field)).getOrElse((Function0 & Serializable)() -> "");
    }

    public String getApplicationPathFromTaskId(String taskId) {
        return this.explorerPath() + "?taskId=" + taskId;
    }

    public String getApplicationPathFromVersionId(String versionId) {
        return this.explorerPath() + "?ciId=" + this.removeSuffixFromPath(versionId);
    }

    public String removeSuffixFromPath(String path) {
        return (String)Option$.MODULE$.apply((Object)path).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).map((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.split("/")), 1)).mkString("/")).getOrElse((Function0 & Serializable)() -> path);
    }

    public boolean isDeleteEvent(SerializableTask task) {
        boolean isUndeployed = this.extractMetadata("taskType", task).equals(TaskType.UNDEPLOY.toString()) && task.getState().equals((Object)TaskExecutionState.DONE);
        boolean isInitialCancelledOrFailed = this.extractMetadata("taskType", task).equals(TaskType.INITIAL.toString()) && (task.getState().equals((Object)TaskExecutionState.CANCELLED) || task.getState().equals((Object)TaskExecutionState.FAILED));
        boolean isInitialRollbacked = this.extractMetadata("rollbackType", task).equals(TaskType.INITIAL.toString()) && task.getState().equals((Object)TaskExecutionState.DONE);
        return isUndeployed || isInitialCancelledOrFailed || isInitialRollbacked;
    }

    public boolean isUpgradeCancelled(SerializableTask task) {
        return this.extractMetadata("taskType", task).equals(TaskType.UPGRADE.toString()) && (task.getState().equals((Object)TaskExecutionState.CANCELLED) || task.getState().equals((Object)TaskExecutionState.FAILED));
    }

    public String resolveTaskApplicationPath(SerializableTask task) {
        if (task.getState().equals((Object)TaskExecutionState.DONE)) {
            return this.getApplicationPathFromVersionId(this.extractMetadata("version_id", task));
        }
        return this.getApplicationPathFromTaskId(task.getId());
    }

    public String resolveApplicationVersion(SerializableTask task) {
        if (this.isUpgradeCancelled(task)) {
            Option deployedApplication = CollectionConverters$.MODULE$.ListHasAsScala(RepositoryServiceHolder.getRepositoryService().listEntities(new SearchParameters().setType(Type.valueOf(DeployedApplication.class)).setName(this.extractMetadata("application", task)))).asScala().find((Function1 & Serializable)app -> BoxesRunTime.boxToBoolean((boolean)DeploymentStatusUtils$.$anonfun$resolveApplicationVersion$1(task, app)));
            return (String)deployedApplication.map((Function1 & Serializable)x$3 -> x$3.getVersion().getVersion()).getOrElse((Function0 & Serializable)() -> "");
        }
        return this.extractMetadata("version", task);
    }

    public String resolveApplicationStatus(SerializableTask task) {
        if (this.isUpgradeCancelled(task)) {
            return TaskExecutionState.DONE.toString();
        }
        return (String)Option$.MODULE$.apply((Object)task.getState()).map((Function1 & Serializable)x$4 -> x$4.toString()).getOrElse((Function0 & Serializable)() -> "-");
    }

    public static final /* synthetic */ boolean $anonfun$resolveApplicationVersion$1(SerializableTask task$1, DeployedApplication app) {
        return app.getEnvironment().getName().equals(MODULE$.extractMetadata("environment", task$1));
    }

    private DeploymentStatusUtils$() {
    }
}

