/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.WrappedMessageTypeIdMapper;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.config.impl.AnnotationConfigurationImpl;
import org.infinispan.protostream.descriptors.AnnotationElement;

public final class ConfigurationImpl
implements Configuration {
    private final boolean logOutOfSequenceReads;
    private final boolean logOutOfSequenceWrites;
    private final WrappingConfigImpl wrappingConfig;
    private final AnnotationsConfigImpl annotationsConfig;
    private final int maxNestedMessageDepth;

    private ConfigurationImpl(boolean logOutOfSequenceReads, boolean logOutOfSequenceWrites, int maxNestedMessageDepth, WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper, Map<String, AnnotationConfigurationImpl> annotations, boolean logUndefinedAnnotations) {
        this.logOutOfSequenceReads = logOutOfSequenceReads;
        this.logOutOfSequenceWrites = logOutOfSequenceWrites;
        this.maxNestedMessageDepth = maxNestedMessageDepth;
        this.wrappingConfig = new WrappingConfigImpl(wrappedMessageTypeIdMapper);
        this.annotationsConfig = new AnnotationsConfigImpl(annotations, logUndefinedAnnotations);
    }

    @Override
    public boolean logOutOfSequenceReads() {
        return this.logOutOfSequenceReads;
    }

    @Override
    public boolean logOutOfSequenceWrites() {
        return this.logOutOfSequenceWrites;
    }

    @Override
    public int maxNestedMessageDepth() {
        return this.maxNestedMessageDepth;
    }

    @Override
    public Configuration.WrappingConfig wrappingConfig() {
        return this.wrappingConfig;
    }

    @Override
    public Configuration.AnnotationsConfig annotationsConfig() {
        return this.annotationsConfig;
    }

    public String toString() {
        return "Configuration{logOutOfSequenceReads=" + this.logOutOfSequenceReads + ", logOutOfSequenceWrites=" + this.logOutOfSequenceWrites + ", wrappingConfig=" + this.wrappingConfig + ", annotationsConfig=" + this.annotationsConfig + "}";
    }

    public static final class BuilderImpl
    implements Configuration.Builder {
        private boolean logOutOfSequenceReads = true;
        private boolean logOutOfSequenceWrites = true;
        private int maxNestedMessageDepth = 100;
        private WrappingConfigBuilderImpl wrappingConfigBuilder = null;
        private AnnotationsConfigBuilderImpl annotationsConfigBuilder = null;

        @Override
        public Configuration.Builder setLogOutOfSequenceReads(boolean logOutOfSequenceReads) {
            this.logOutOfSequenceReads = logOutOfSequenceReads;
            return this;
        }

        @Override
        public Configuration.Builder setLogOutOfSequenceWrites(boolean logOutOfSequenceWrites) {
            this.logOutOfSequenceWrites = logOutOfSequenceWrites;
            return this;
        }

        @Override
        public Configuration.Builder maxNestedMessageDepth(int maxNestedMessageDepth) {
            this.maxNestedMessageDepth = maxNestedMessageDepth;
            return this;
        }

        @Override
        public WrappingConfigBuilderImpl wrappingConfig() {
            if (this.wrappingConfigBuilder == null) {
                this.wrappingConfigBuilder = new WrappingConfigBuilderImpl();
            }
            return this.wrappingConfigBuilder;
        }

        @Override
        public AnnotationsConfigBuilderImpl annotationsConfig() {
            if (this.annotationsConfigBuilder == null) {
                this.annotationsConfigBuilder = new AnnotationsConfigBuilderImpl();
            }
            return this.annotationsConfigBuilder;
        }

        @Override
        public Configuration build() {
            this.annotationsConfig().annotation("TypeId", AnnotationElement.AnnotationTarget.MESSAGE, AnnotationElement.AnnotationTarget.ENUM).attribute("value").type(AnnotationElement.AttributeType.INT).metadataCreator((annotatedDescriptor, annotation) -> annotation.getDefaultAttributeValue().getValue());
            AnnotationsConfigBuilderImpl annotationsConfig = this.annotationsConfig();
            HashMap<String, AnnotationConfigurationImpl> annotations = new HashMap<String, AnnotationConfigurationImpl>(annotationsConfig.annotationBuilders.size());
            for (AnnotationConfiguration.Builder builder : annotationsConfig.annotationBuilders.values()) {
                AnnotationConfigurationImpl annotationConfig = ((AnnotationConfigurationImpl.BuilderImpl)builder).buildAnnotationConfiguration();
                annotations.put(annotationConfig.name(), annotationConfig);
            }
            for (AnnotationConfigurationImpl annotationConfigurationImpl : annotations.values()) {
                String repeatable = annotationConfigurationImpl.repeatable();
                if (repeatable == null) continue;
                AnnotationConfigurationImpl container = (AnnotationConfigurationImpl)annotations.get(repeatable);
                if (container == null) {
                    throw new IllegalStateException("Containing annotation '" + repeatable + "' of repeatable annotation '" + annotationConfigurationImpl.name() + "' was not found in configuration.");
                }
                annotationConfigurationImpl.container = container;
            }
            boolean logUndefinedAnnotations = this.annotationsConfig().logUndefinedAnnotations == null ? annotations.size() > 1 : this.annotationsConfig().logUndefinedAnnotations;
            return new ConfigurationImpl(this.logOutOfSequenceReads, this.logOutOfSequenceWrites, this.maxNestedMessageDepth, this.wrappingConfig().wrappedMessageTypeIdMapper, annotations, logUndefinedAnnotations);
        }

        final class AnnotationsConfigBuilderImpl
        implements Configuration.AnnotationsConfig.Builder {
            private Boolean logUndefinedAnnotations = null;
            final Map<String, AnnotationConfigurationImpl.BuilderImpl> annotationBuilders = new HashMap<String, AnnotationConfigurationImpl.BuilderImpl>();

            AnnotationsConfigBuilderImpl() {
            }

            @Override
            public Configuration.AnnotationsConfig.Builder setLogUndefinedAnnotations(boolean logUndefinedAnnotations) {
                this.logUndefinedAnnotations = logUndefinedAnnotations;
                return this;
            }

            @Override
            public AnnotationConfiguration.Builder annotation(String annotationName, AnnotationElement.AnnotationTarget ... target) {
                if (this.annotationBuilders.containsKey(annotationName)) {
                    throw new IllegalArgumentException("Duplicate annotation name definition: " + annotationName);
                }
                if (target == null || target.length == 0) {
                    throw new IllegalArgumentException("At least one target must be specified for annotation: " + annotationName);
                }
                AnnotationConfigurationImpl.BuilderImpl builder = new AnnotationConfigurationImpl.BuilderImpl(this, annotationName, target);
                this.annotationBuilders.put(annotationName, builder);
                return builder;
            }

            @Override
            public Configuration build() {
                return BuilderImpl.this.build();
            }
        }

        final class WrappingConfigBuilderImpl
        implements Configuration.WrappingConfig.Builder {
            private WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper;

            WrappingConfigBuilderImpl() {
            }

            @Override
            public Configuration.WrappingConfig.Builder wrappedMessageTypeIdMapper(WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper) {
                this.wrappedMessageTypeIdMapper = wrappedMessageTypeIdMapper;
                return this;
            }

            @Override
            public Configuration build() {
                return BuilderImpl.this.build();
            }
        }
    }

    private static final class AnnotationsConfigImpl
    implements Configuration.AnnotationsConfig {
        private final Map<String, AnnotationConfiguration> annotations;
        private final boolean logUndefinedAnnotations;

        AnnotationsConfigImpl(Map<String, AnnotationConfigurationImpl> annotations, boolean logUndefinedAnnotations) {
            this.annotations = Collections.unmodifiableMap(annotations);
            this.logUndefinedAnnotations = logUndefinedAnnotations;
        }

        @Override
        public boolean logUndefinedAnnotations() {
            return this.logUndefinedAnnotations;
        }

        @Override
        public Map<String, AnnotationConfiguration> annotations() {
            return this.annotations;
        }

        public String toString() {
            return "AnnotationsConfig{annotations=" + this.annotations + ", logUndefinedAnnotations=" + this.logUndefinedAnnotations + "}";
        }
    }

    private static final class WrappingConfigImpl
    implements Configuration.WrappingConfig {
        private final WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper;

        private WrappingConfigImpl(WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper) {
            this.wrappedMessageTypeIdMapper = wrappedMessageTypeIdMapper;
        }

        @Override
        public WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper() {
            return this.wrappedMessageTypeIdMapper;
        }

        public String toString() {
            return "WrappingConfigImpl{wrappedMessageTypeIdMapper=" + this.wrappedMessageTypeIdMapper + "}";
        }
    }
}

