/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;

public class HANARowStoreDialect
extends AbstractHANADialect {
    public HANARowStoreDialect(DialectResolutionInfo info) {
        this(AbstractHANADialect.createVersion(info));
        this.registerKeywords(info);
    }

    public HANARowStoreDialect() {
        this(DatabaseVersion.make(1, 0, 120));
    }

    public HANARowStoreDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    public String getCreateTableString() {
        return "create row table";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "create global temporary row table";
    }

    @Override
    public String getTemporaryTableTruncateCommand() {
        return "truncate table";
    }

    @Override
    protected boolean supportsAsciiStringTypes() {
        return true;
    }

    @Override
    protected Boolean useUnicodeStringTypesDefault() {
        return Boolean.FALSE;
    }
}

