/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.lang.reflect.Array;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public class ArrayConverter<X, Y>
implements BasicValueConverter<X, Y> {
    private final BasicValueConverter<Object, Object> elementConverter;
    private final JavaType<X> domainJavaType;
    private final JavaType<Y> relationalJavaType;

    public ArrayConverter(BasicValueConverter<Object, Object> elementConverter, JavaType<X> domainJavaType, JavaType<Y> relationalJavaType) {
        this.elementConverter = elementConverter;
        this.domainJavaType = domainJavaType;
        this.relationalJavaType = relationalJavaType;
    }

    @Override
    public X toDomainValue(Y relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        if (relationalForm.getClass().getComponentType() == this.elementConverter.getDomainJavaType().getJavaTypeClass()) {
            return (X)relationalForm;
        }
        Object[] relationalArray = (Object[])relationalForm;
        Object[] domainArray = (Object[])Array.newInstance(this.elementConverter.getDomainJavaType().getJavaTypeClass(), relationalArray.length);
        for (int i = 0; i < relationalArray.length; ++i) {
            domainArray[i] = this.elementConverter.toDomainValue(relationalArray[i]);
        }
        return (X)domainArray;
    }

    @Override
    public Y toRelationalValue(X domainForm) {
        if (domainForm == null) {
            return null;
        }
        if (domainForm.getClass().getComponentType() == this.elementConverter.getRelationalJavaType().getJavaTypeClass()) {
            return (Y)domainForm;
        }
        Object[] domainArray = (Object[])domainForm;
        Object[] relationalArray = (Object[])Array.newInstance(this.elementConverter.getRelationalJavaType().getJavaTypeClass(), domainArray.length);
        for (int i = 0; i < domainArray.length; ++i) {
            relationalArray[i] = this.elementConverter.toRelationalValue(domainArray[i]);
        }
        return (Y)relationalArray;
    }

    @Override
    public JavaType<X> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<Y> getRelationalJavaType() {
        return this.relationalJavaType;
    }
}

