/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.internal.AbstractMutationOperationGroup;

public class MutationOperationGroupSingle
extends AbstractMutationOperationGroup {
    private final MutationOperation operation;

    public MutationOperationGroupSingle(MutationType mutationType, MutationTarget<?> mutationTarget, MutationOperation operation) {
        super(mutationType, mutationTarget);
        this.operation = operation;
    }

    public MutationOperationGroupSingle(MutationGroup mutationGroup, MutationOperation operation) {
        this(mutationGroup.getMutationType(), mutationGroup.getMutationTarget(), operation);
    }

    @Override
    public int getNumberOfOperations() {
        return 1;
    }

    @Override
    public <O extends MutationOperation> O getSingleOperation() {
        return (O)this.operation;
    }

    @Override
    public <O extends MutationOperation> List<O> getOperations() {
        return Collections.singletonList(this.operation);
    }

    @Override
    public <O extends MutationOperation> O getOperation(String tableName) {
        if (!tableName.equals(this.operation.getTableDetails().getTableName())) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Unexpected table name mismatch : `%s` - `%s`", (Object)tableName, (Object)this.operation.getTableDetails().getTableName());
        }
        return (O)this.operation;
    }

    @Override
    public <O extends MutationOperation> void forEachOperation(BiConsumer<Integer, O> action) {
        action.accept(0, this.operation);
    }

    @Override
    public <O extends MutationOperation> boolean hasMatching(BiFunction<Integer, O, Boolean> matcher) {
        return matcher.apply(0, this.operation);
    }
}

