/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ComparisonRestriction;
import org.hibernate.sql.NullnessRestriction;
import org.hibernate.sql.Restriction;
import org.hibernate.sql.RestrictionRenderingContext;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

@Internal
public class Update
implements RestrictionRenderingContext {
    protected String tableName;
    protected String comment;
    protected Map<String, String> assignments = new LinkedHashMap<String, String>();
    protected List<Restriction> restrictions = new ArrayList<Restriction>();
    private final ParameterMarkerStrategy parameterMarkerStrategy;
    private int parameterCount;

    public Update(SessionFactoryImplementor factory) {
        this(factory.getFastSessionServices().parameterMarkerStrategy);
    }

    public Update(ParameterMarkerStrategy parameterMarkerStrategy) {
        this.parameterMarkerStrategy = parameterMarkerStrategy;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Update setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Update setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Update addAssignments(String ... columnNames) {
        for (String columnName : columnNames) {
            this.addAssignment(columnName);
        }
        return this;
    }

    public Update addAssignment(String columnName) {
        return this.addAssignment(columnName, "?");
    }

    public Update addAssignment(String columnName, String valueExpression) {
        this.assignments.put(columnName, valueExpression);
        return this;
    }

    public Update addRestriction(String column) {
        this.restrictions.add(new ComparisonRestriction(column));
        return this;
    }

    public Update addRestriction(String ... columns) {
        for (int i = 0; i < columns.length; ++i) {
            String columnName = columns[i];
            if (columnName == null) continue;
            this.addRestriction(columnName);
        }
        return this;
    }

    public Update addRestriction(String column, String value) {
        this.restrictions.add(new ComparisonRestriction(column, value));
        return this;
    }

    public Update addRestriction(String column, ComparisonRestriction.Operator op, String value) {
        this.restrictions.add(new ComparisonRestriction(column, op, value));
        return this;
    }

    private String normalizeExpressionFragment(String rhs) {
        return rhs.equals("?") ? this.parameterMarkerStrategy.createMarker(++this.parameterCount, null) : rhs;
    }

    public Update addColumnIsNullRestriction(String columnName) {
        this.restrictions.add(new NullnessRestriction(columnName));
        return this;
    }

    public Update addColumnIsNotNullRestriction(String columnName) {
        this.restrictions.add(new NullnessRestriction(columnName, false));
        return this;
    }

    public String toStatementString() {
        StringBuilder buf = new StringBuilder(this.assignments.size() * 15 + this.tableName.length() + 10);
        this.applyComment(buf);
        buf.append("update ").append(this.tableName);
        this.applyAssignments(buf);
        this.applyRestrictions(buf);
        return buf.toString();
    }

    private void applyComment(StringBuilder buf) {
        if (this.comment != null) {
            buf.append("/* ").append(Dialect.escapeComment(this.comment)).append(" */ ");
        }
    }

    private void applyAssignments(StringBuilder buf) {
        buf.append(" set ");
        Iterator<Map.Entry<String, String>> entries = this.assignments.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            buf.append(entry.getKey()).append('=').append(this.normalizeExpressionFragment(entry.getValue()));
            if (!entries.hasNext()) continue;
            buf.append(", ");
        }
    }

    private void applyRestrictions(StringBuilder buf) {
        if (this.restrictions.isEmpty()) {
            return;
        }
        buf.append(" where ");
        for (int i = 0; i < this.restrictions.size(); ++i) {
            if (i > 0) {
                buf.append(" and ");
            }
            Restriction restriction = this.restrictions.get(i);
            restriction.render(buf, this);
        }
    }

    @Override
    public String makeParameterMarker() {
        return this.parameterMarkerStrategy.createMarker(++this.parameterCount, null);
    }
}

