/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.annotation.Nullable;

final class ContextAwareHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final ContextAwareHttpServerMetricsRecorder recorder;

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
    }

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
    }

    @Override
    protected ContextAwareHttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void contextView(HttpServerOperations ops) {
        this.contextView = ops.currentContext();
    }

    @Override
    protected void recordException() {
        this.recorder().incrementErrorsCount(this.contextView, this.remoteSocketAddress, this.path);
    }

    @Override
    protected void recordRead() {
        this.recorder().recordDataReceivedTime(this.contextView, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(this.contextView, this.remoteSocketAddress, this.path, this.dataReceived);
    }

    @Override
    protected void recordWrite(Channel channel) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(this.contextView, this.path, this.method, this.status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(this.contextView, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(this.contextView, this.path, this.method, this.status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(this.contextView, this.remoteSocketAddress, this.path, this.dataSent);
    }
}

