/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

class KeystoreUtil {
    private static final CertificateFactory CERTIFICATE_FACTORY;
    private static final KeyFactory RSA_KEY_FACTORY;
    private static final KeyFactory EC_KEY_FACTORY;

    KeystoreUtil() {
    }

    static KeyStore createKeyStore(String keyAlias, KeySpec privateKeySpec, char[] keyPassword, X509Certificate ... certificates) throws GeneralSecurityException, IOException {
        Assert.notNull((Object)keyPassword, (String)"keyPassword must not be null");
        PrivateKey privateKey = privateKeySpec instanceof RSAPrivateKeySpec || privateKeySpec instanceof PKCS8EncodedKeySpec ? RSA_KEY_FACTORY.generatePrivate(privateKeySpec) : EC_KEY_FACTORY.generatePrivate(privateKeySpec);
        KeyStore keyStore = KeystoreUtil.createKeyStore();
        ArrayList certChain = new ArrayList();
        Collections.addAll(certChain, certificates);
        keyStore.setKeyEntry(keyAlias, privateKey, keyPassword, certChain.toArray(new Certificate[certChain.size()]));
        return keyStore;
    }

    static KeyStore createKeyStore(X509Certificate ... certificates) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeystoreUtil.createKeyStore();
        int counter = 0;
        for (X509Certificate certificate : certificates) {
            keyStore.setCertificateEntry(String.format("cert_%d", counter++), certificate);
        }
        return keyStore;
    }

    static X509Certificate getCertificate(byte[] source) throws CertificateException {
        List<X509Certificate> certificates = KeystoreUtil.getCertificates(CERTIFICATE_FACTORY, source);
        return (X509Certificate)certificates.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No X509Certificate found"));
    }

    static List<X509Certificate> getCertificates(byte[] source) throws CertificateException {
        return KeystoreUtil.getCertificates(CERTIFICATE_FACTORY, source);
    }

    private static KeyStore createKeyStore() throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, new char[0]);
        return keyStore;
    }

    private static List<X509Certificate> getCertificates(CertificateFactory cf, byte[] source) throws CertificateException {
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        ByteArrayInputStream bis = new ByteArrayInputStream(source);
        while (bis.available() > 0) {
            Certificate cert = cf.generateCertificate(bis);
            if (!(cert instanceof X509Certificate)) continue;
            x509Certificates.add((X509Certificate)cert);
        }
        return x509Certificates;
    }

    static {
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("No X.509 Certificate available", e);
        }
        try {
            RSA_KEY_FACTORY = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No RSA KeyFactory available", e);
        }
        try {
            EC_KEY_FACTORY = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No EC KeyFactory available", e);
        }
    }
}

