/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.task.archive.ArchivedAbstractBlock;
import java.util.ArrayList;
import java.util.List;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;

public class ArchivedCompositeBlock
extends ArchivedAbstractBlock
implements CompositeBlockState {
    private List<BlockState> blocks = Lists.newArrayList();
    private boolean parallel;

    public boolean isParallel() {
        return this.parallel;
    }

    public List<BlockState> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<BlockState> blocks) {
        this.blocks = blocks;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public List<StepState> getStepList() {
        ArrayList steps = Lists.newArrayList();
        for (BlockState block : this.blocks) {
            steps.addAll(((ArchivedAbstractBlock)block).getStepList());
        }
        return steps;
    }

    public StepState getStep(BlockPath path) {
        int head = path.head();
        return ((ArchivedAbstractBlock)this.blocks.get(head - 1)).getStep(path.tail());
    }

    public Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply((Object)this);
        }
        int head = path.head();
        return ((ArchivedAbstractBlock)this.blocks.get(head - 1)).getBlock(path.tail());
    }

    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        ListBuffer swp = new ListBuffer();
        for (BlockState block : this.blocks) {
            swp.appendAll((IterableOnce)((ArchivedAbstractBlock)block).getStepsWithPaths());
        }
        return swp.toSeq();
    }
}

