/*
 * Decompiled with CFR 0.152.
 */
package kamon.status;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kamon.status.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.runtime.BoxedUnit;

public final class InstrumentationStatus$ {
    public static final InstrumentationStatus$ MODULE$ = new InstrumentationStatus$();
    private static final Logger _logger = LoggerFactory.getLogger((String)"kamon.status.Status.Instrumentation");
    private static final String _kanelaLoadedPropertyName = "kanela.loaded";
    private static final String _registryClassName = "kanela.agent.api.instrumentation.listener.InstrumentationRegistryListener";

    private Logger _logger() {
        return _logger;
    }

    private String _kanelaLoadedPropertyName() {
        return _kanelaLoadedPropertyName;
    }

    private String _registryClassName() {
        return _registryClassName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Status.Instrumentation create(boolean warnIfFailed) {
        Status.Instrumentation instrumentation;
        try {
            boolean kanelaLoaded = Boolean.parseBoolean(System.getProperty(this._kanelaLoadedPropertyName()));
            Class<?> registryClass = Class.forName(this._registryClassName(), false, ClassLoader.getSystemClassLoader());
            boolean present = registryClass != null && kanelaLoaded;
            String kanelaVersion = (String)Class.forName("kanela.agent.util.BuildInfo", false, ClassLoader.getSystemClassLoader()).getMethod("version", new Class[0]).invoke(null, new Object[0]);
            Buffer modules = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter((List)registryClass.getMethod("shareModules", new Class[0]).invoke(null, new Object[0])).asScala()).map((Function1 & Serializable)map -> MODULE$.toModule((Map<String, String>)map));
            Seq errors = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)registryClass.getMethod("shareErrors", new Class[0]).invoke(null, new Object[0])).asScala()).map((Function1 & Serializable)pair -> MODULE$.toTypeError((Tuple2<String, List<Throwable>>)pair))).toSeq();
            instrumentation = new Status.Instrumentation(present, (Option<String>)Option$.MODULE$.apply((Object)kanelaVersion), (Seq<Status.Instrumentation.ModuleInfo>)modules.toSeq(), (Seq<Status.Instrumentation.TypeError>)errors);
            return instrumentation;
        }
        catch (Throwable t) {
            if (warnIfFailed) {
                Throwable throwable = t;
                if (throwable instanceof ClassNotFoundException && warnIfFailed) {
                    this._logger().warn("Failed to load the instrumentation modules status because the Kanela agent is not available");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (throwable == null) throw new MatchError((Object)throwable);
                    Throwable throwable2 = throwable;
                    if (!warnIfFailed) throw new MatchError((Object)throwable);
                    this._logger().warn("Failed to load the instrumentation modules status", throwable2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            instrumentation = new Status.Instrumentation(false, (Option<String>)None$.MODULE$, (Seq<Status.Instrumentation.ModuleInfo>)((Seq)package$.MODULE$.Seq().empty()), (Seq<Status.Instrumentation.TypeError>)((Seq)package$.MODULE$.Seq().empty()));
        }
        return instrumentation;
    }

    public boolean create$default$1() {
        return true;
    }

    private Status.Instrumentation.ModuleInfo toModule(Map<String, String> map) {
        return new Status.Instrumentation.ModuleInfo(map.get("path"), map.get("name"), map.get("description"), Boolean.parseBoolean(map.get("enabled")), Boolean.parseBoolean(map.get("active")));
    }

    private Status.Instrumentation.TypeError toTypeError(Tuple2<String, List<Throwable>> pair) {
        Tuple2<String, List<Throwable>> tuple2 = pair;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String typeName = (String)tuple2._1();
        List errors = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)typeName, (Object)errors);
        Tuple2 tuple23 = tuple22;
        String typeName2 = (String)tuple23._1();
        List errors2 = (List)tuple23._2();
        return new Status.Instrumentation.TypeError(typeName2, (Seq<Throwable>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(errors2).asScala()).toSeq());
    }

    private InstrumentationStatus$() {
    }
}

