/*
 * Decompiled with CFR 0.152.
 */
package kamon;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import kamon.Configuration;
import kamon.CurrentStatus;
import kamon.Metrics;
import kamon.ModuleManagement;
import kamon.Tracing;
import kamon.package$;
import kamon.status.BuildInfo$;
import kamon.status.InstrumentationStatus$;
import kamon.status.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005q4\u0001\u0002E\t\u0011\u0002\u0007\u0005A\u0003\u0019\u0005\u00067\u0001!\t\u0001\b\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0011\u001dQ\u0003\u00011A\u0005\n-Bq!\u0010\u0001A\u0002\u0013%a\bC\u0003B\u0001\u0011\u0005A\u0004C\u0003B\u0001\u0011\u0005!\tC\u0003O\u0001\u0011\u0005A\u0004C\u0003O\u0001\u0011\u0005q\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003Y\u0001\u0011\u0005A\u0004C\u0003Z\u0001\u0011%A\u0004C\u0003[\u0001\u0011%A\u0004C\u0003\\\u0001\u0011%A\u0004C\u0003]\u0001\u0011%A\u0004C\u0003^\u0001\u0011%aL\u0001\u0003J]&$(\"\u0001\n\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005i\u0002C\u0001\f\u001f\u0013\tyrC\u0001\u0003V]&$\u0018aB0m_\u001e<WM]\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006g24GG\u001b\u0006\u0002O\u0005\u0019qN]4\n\u0005%\"#A\u0002'pO\u001e,'/\u0001\u0006`g\u000eDW\rZ;mKJ,\u0012\u0001\f\t\u0004-5z\u0013B\u0001\u0018\u0018\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0003Y\nAA[1wC&\u0011\u0001(\r\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007FA\u0002;!\t12(\u0003\u0002=/\tAao\u001c7bi&dW-\u0001\b`g\u000eDW\rZ;mKJ|F%Z9\u0015\u0005uy\u0004b\u0002!\u0005\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0014\u0001B5oSR$\"!H\"\t\u000b\u00113\u0001\u0019A#\u0002\r\r|gNZ5h!\t1E*D\u0001H\u0015\t!\u0005J\u0003\u0002J\u0015\u0006AA/\u001f9fg\u00064WMC\u0001L\u0003\r\u0019w.\\\u0005\u0003\u001b\u001e\u0013aaQ8oM&<\u0017\u0001F5oSR<\u0016\u000e\u001e5pkR\fE\u000f^1dQ&tw\r\u0006\u0002\u001e!\")A\t\u0003a\u0001\u000b\u0006!1\u000f^8q)\u0005\u0019\u0006c\u0001+W;5\tQK\u0003\u00023/%\u0011q+\u0016\u0002\u0007\rV$XO]3\u0002+\u0005$H/Y2i\u0013:\u001cHO];nK:$\u0018\r^5p]\u0006\tBn\\4J]&$8\u000b^1ukNLeNZ8\u0002-\u0011L7/\u00192mK&s7\u000f\u001e:v[\u0016tG/\u0019;j_:\fQ\"\u001b8jiN\u001b\u0007.\u001a3vY\u0016\u0014\u0018!D:u_B\u001c6\r[3ek2,'/A\bsK\u000e|gNZ5hkJ,\u0017J\\5u)\tir\fC\u0003E\u001f\u0001\u0007QIE\u0002bG\u00164AA\u0019\u0001\u0001A\naAH]3gS:,W.\u001a8u}A\u0011A\rA\u0007\u0002#IAam\u001a6naN4\u0018P\u0002\u0003c\u0001\u0001)\u0007C\u00013i\u0013\tI\u0017C\u0001\tN_\u0012,H.Z'b]\u0006<W-\\3oiB\u0011Am[\u0005\u0003YF\u0011QbQ8oM&<WO]1uS>t\u0007C\u00013o\u0013\ty\u0017CA\u0007DkJ\u0014XM\u001c;Ti\u0006$Xo\u001d\t\u0003IFL!A]\t\u0003\u000f5+GO]5dgB\u0011A\r^\u0005\u0003kF\u0011\u0011\"\u0016;jY&$\u0018.Z:\u0011\u0005\u0011<\u0018B\u0001=\u0012\u0005\u001d!&/Y2j]\u001e\u0004\"\u0001\u001a>\n\u0005m\f\"AD\"p]R,\u0007\u0010^*u_J\fw-\u001a")
public interface Init {
    public void kamon$Init$_setter_$kamon$Init$$_logger_$eq(Logger var1);

    public Logger kamon$Init$$_logger();

    public Option<ScheduledExecutorService> kamon$Init$$_scheduler();

    public void kamon$Init$$_scheduler_$eq(Option<ScheduledExecutorService> var1);

    public static /* synthetic */ void init$(Init $this) {
        $this.init();
    }

    default public void init() {
        if (((Configuration)((Object)this)).enabled()) {
            this.attachInstrumentation();
            this.initScheduler();
            ((ModuleManagement)((Object)this)).loadModules();
            ((ModuleManagement)((Object)this)).moduleRegistry().init();
        } else {
            this.disableInstrumentation();
        }
        this.logInitStatusInfo();
    }

    public static /* synthetic */ void init$(Init $this, Config config) {
        $this.init(config);
    }

    default public void init(Config config) {
        ((Configuration)((Object)this)).reconfigure(config);
        if (((Configuration)((Object)this)).enabled()) {
            this.attachInstrumentation();
            this.initScheduler();
            ((ModuleManagement)((Object)this)).loadModules();
            ((ModuleManagement)((Object)this)).moduleRegistry().init();
        } else {
            this.disableInstrumentation();
        }
        this.logInitStatusInfo();
    }

    public static /* synthetic */ void initWithoutAttaching$(Init $this) {
        $this.initWithoutAttaching();
    }

    default public void initWithoutAttaching() {
        if (((Configuration)((Object)this)).enabled()) {
            this.initScheduler();
            ((ModuleManagement)((Object)this)).loadModules();
            ((ModuleManagement)((Object)this)).moduleRegistry().init();
        } else {
            this.disableInstrumentation();
        }
        this.logInitStatusInfo();
    }

    public static /* synthetic */ void initWithoutAttaching$(Init $this, Config config) {
        $this.initWithoutAttaching(config);
    }

    default public void initWithoutAttaching(Config config) {
        ((Configuration)((Object)this)).reconfigure(config);
        if (((Configuration)((Object)this)).enabled()) {
            this.initWithoutAttaching();
        } else {
            this.disableInstrumentation();
        }
        this.logInitStatusInfo();
    }

    public static /* synthetic */ Future stop$(Init $this) {
        return $this.stop();
    }

    default public Future<BoxedUnit> stop() {
        ((Metrics)((Object)this)).clearRegistry();
        this.stopScheduler();
        ((ModuleManagement)((Object)this)).moduleRegistry().shutdown();
        return ((ModuleManagement)((Object)this)).stopModules();
    }

    public static /* synthetic */ void attachInstrumentation$(Init $this) {
        $this.attachInstrumentation();
    }

    default public void attachInstrumentation() {
        block3: {
            if (InstrumentationStatus$.MODULE$.create(false).present()) break block3;
            try {
                Class<?> attacherClass = Class.forName("kamon.runtime.Attacher");
                Method attachMethod = attacherClass.getDeclaredMethod("attach", new Class[0]);
                attachMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.kamon$Init$$_logger().warn("Your application is running without the Kanela instrumentation agent. None of Kamon's automatic instrumentation will be applied to the current JVM. Consider using the kamon-bundle dependency or setting up the Kanela agent via the -javaagent:/path/to/kanela.jar command-line option");
            }
            catch (Throwable t) {
                this.kamon$Init$$_logger().error("Failed to attach the Kanela agent included in the kamon-bundle", t);
            }
        }
    }

    private void logInitStatusInfo() {
        boolean showBanner;
        boolean isEnabled = ((Configuration)((Object)this)).enabled();
        boolean bl = showBanner = !((Configuration)((Object)this)).config().getBoolean("kamon.init.hide-banner");
        if (isEnabled) {
            Status.Instrumentation instrumentationStatus = ((CurrentStatus)((Object)this)).status().instrumentation();
            String kanelaVersion = (String)instrumentationStatus.kanelaVersion().map((Function1 & Serializable)v -> Init.green$1(new StringBuilder(1).append("v").append((String)v).toString())).getOrElse((Function0 & Serializable)() -> Init.red$1("not found"));
            if (showBanner) {
                this.kamon$Init$$_logger().info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(345).append("\n             | _\n             || |\n             || | ____ _ _ __ ___   ___  _ __\n             || |/ / _  |  _ ` _ \\ / _ \\|  _ \\\n             ||   < (_| | | | | | | (_) | | | |\n             ||_|\\_\\__,_|_| |_| |_|\\___/|_| |_|\n             |=====================================\n             |Initializing Kamon Telemetry ").append(Init.green$1(new StringBuilder(1).append("v").append(BuildInfo$.MODULE$.version()).toString())).append(" / Kanela ").append(kanelaVersion).append("\n             |").toString())));
            } else {
                this.kamon$Init$$_logger().info(new StringBuilder(40).append("Initializing Kamon Telemetry v").append(BuildInfo$.MODULE$.version()).append(" / Kanela ").append(kanelaVersion).toString());
            }
        } else {
            this.kamon$Init$$_logger().warn(new StringBuilder(84).append(new StringBuilder(89).append("Kamon is ").append(Init.red$1("DISABLED")).append(". No instrumentation, reporters, or context propagation will be applied on this ").toString()).append("process. Restart the process with kamon.enabled=yes to restore Kamon's functionality").toString());
        }
    }

    private void disableInstrumentation() {
        try {
            Class.forName("kanela.agent.Kanela", true, ClassLoader.getSystemClassLoader()).getDeclaredMethod("disable", new Class[0]).invoke(null, new Object[0]);
            this.kamon$Init$$_logger().info("Disabled the Kanela instrumentation agent. Classes will not be instrumented in this process");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.kamon$Init$$_logger().error("Failed to disable the Kanela instrumentation agent. Please ensure you are using Kanela >=1.0.17");
        }
        catch (Throwable t) {
            this.kamon$Init$$_logger().error("Failed to disable the Kanela instrumentation agent", t);
        }
    }

    private void initScheduler() {
        Init init = this;
        synchronized (init) {
            ScheduledExecutorService newScheduler = package$.MODULE$.newScheduledThreadPool(2, package$.MODULE$.numberedThreadFactory("kamon-scheduler", true));
            ((Tracing)((Object)this)).tracer().bindScheduler(newScheduler);
            ((Metrics)((Object)this)).registry().bindScheduler(newScheduler);
        }
    }

    private void stopScheduler() {
        Init init = this;
        synchronized (init) {
            ((Tracing)((Object)this)).tracer().shutdown();
            ((Metrics)((Object)this)).registry().shutdown();
            this.kamon$Init$$_scheduler().foreach((Function1 & Serializable)x$1 -> {
                x$1.shutdown();
                return BoxedUnit.UNIT;
            });
            this.kamon$Init$$_scheduler_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
        }
    }

    private void reconfigureInit(Config config) {
        this.kamon$Init$$_scheduler().foreach((Function1 & Serializable)x0$1 -> {
            Init.$anonfun$reconfigureInit$1(config, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static String bold$1(String text) {
        return new StringBuilder(8).append("\u001b[1m").append(text).append("\u001b[0m").toString();
    }

    private static String red$1(String text) {
        return Init.bold$1(new StringBuilder(9).append("\u001b[31m").append(text).append("\u001b[0m").toString());
    }

    private static String green$1(String text) {
        return Init.bold$1(new StringBuilder(9).append("\u001b[32m").append(text).append("\u001b[0m").toString());
    }

    public static /* synthetic */ void $anonfun$reconfigureInit$1(Config config$1, ScheduledExecutorService x0$1) {
        ScheduledExecutorService scheduledExecutorService = x0$1;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            int newPoolSize = config$1.getInt("kamon.scheduler-pool-size");
            scheduledThreadPoolExecutor.setCorePoolSize(newPoolSize);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void $init$(Init $this) {
        $this.kamon$Init$_setter_$kamon$Init$$_logger_$eq(LoggerFactory.getLogger(Init.class));
        $this.kamon$Init$$_scheduler_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
        ((Configuration)((Object)$this)).onReconfigure((Function1<Config, BoxedUnit>)(Function1 & Serializable)newConfig -> {
            $this.reconfigureInit(newConfig);
            return BoxedUnit.UNIT;
        });
    }
}

