/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Property;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.database.DatabaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConfig
extends ProjectComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStep.class);
    private Set properties = new HashSet();
    private Set features = new HashSet();

    public void addProperty(Property property) {
        logger.trace("addProperty(property={}) - start)", (Object)property);
        this.properties.add(property);
    }

    public void addFeature(Feature feature) {
        logger.trace("addFeature(feature={}) - start)", (Object)feature);
        this.features.add(feature);
    }

    public void copyTo(DatabaseConfig config) throws DatabaseUnitException {
        String propValue;
        String propName;
        Properties javaProps = new Properties();
        for (Feature feature : this.features) {
            propName = feature.getName();
            propValue = String.valueOf(feature.isValue());
            logger.debug("Setting property {}", (Object)feature);
            javaProps.setProperty(propName, propValue);
        }
        for (Property prop : this.properties) {
            propName = prop.getName();
            propValue = prop.getValue();
            if (propName == null) {
                throw new NullPointerException("The propName must not be null");
            }
            if (propValue == null) {
                throw new NullPointerException("The propValue must not be null");
            }
            logger.debug("Setting property {}", (Object)prop);
            javaProps.setProperty(propName, propValue);
        }
        config.setPropertiesByString(javaProps);
    }

    public static class Feature {
        private String name;
        private boolean value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }
}

