/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.io.AbstractConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.SimpleImmutableEntry;
import org.infinispan.commons.util.Util;

public class YamlConfigurationReader
extends AbstractConfigurationReader {
    private static final int INDENT = 2;
    private final Deque<Parsed> state = new ArrayDeque<Parsed>();
    private final List<String> attributeNames = new ArrayList<String>();
    private final List<String> attributeValues = new ArrayList<String>();
    private final List<String> attributeNamespaces = new ArrayList<String>();
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final BufferedReader reader;
    private Parsed next;
    private ConfigurationReader.ElementType type = ConfigurationReader.ElementType.START_DOCUMENT;
    private int row = 0;
    private Node lines;

    public YamlConfigurationReader(Reader reader, ConfigurationResourceResolver resolver, Properties properties, PropertyReplacer replacer, NamingStrategy namingStrategy) {
        super(resolver, properties, replacer, namingStrategy);
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.namespaces.put("", "");
        this.loadTree();
        if (Log.CONFIG.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printTree(pw, this.lines);
            Log.CONFIG.trace(sw);
        }
    }

    private void printTree(PrintWriter pw, Node node) {
        if (node != null) {
            for (int i = 0; i < node.parsed.indent; ++i) {
                pw.print(' ');
            }
            pw.println(node.parsed);
            if (node.children != null) {
                for (Node c : node.children) {
                    this.printTree(pw, c);
                }
            }
        }
    }

    private void loadTree() {
        Node current = null;
        while (true) {
            Parsed parsed;
            try {
                while ((parsed = this.parseLine(this.reader.readLine())) != null && parsed.name == null && parsed.value == null && !parsed.listItem) {
                }
            }
            catch (IOException e) {
                throw new ConfigurationReaderException(e, Location.of(this.row, 1));
            }
            if (parsed == null) {
                return;
            }
            if (this.lines == null) {
                if (parsed.name == null) {
                    throw new ConfigurationReaderException("Incomplete line", Location.of(this.row, 1));
                }
                current = this.lines = new Node(parsed);
                continue;
            }
            if (parsed.listItem && parsed.value == null) {
                current = this.findParent(current, parsed);
                current = this.addListItem(parsed, current);
                current = current.addChild(new Node(parsed));
                continue;
            }
            if (parsed.indent == current.parsed.indent) {
                current = current.addSibling(new Node(parsed));
                continue;
            }
            if (parsed.indent > current.parsed.indent) {
                if (parsed.listItem && parsed.name != null) {
                    current = this.addListItem(parsed, current);
                } else if (!parsed.listItem && parsed.name == null) {
                    current.parsed.value = current.parsed.value + " " + parsed.value;
                    continue;
                }
                current = current.addChild(new Node(parsed));
                continue;
            }
            current = this.findParent(current, parsed);
            if (parsed.listItem && parsed.name != null) {
                current = this.addListItem(parsed, current);
            }
            current = current.addChild(new Node(parsed));
        }
    }

    private Node addListItem(Parsed parsed, Node current) {
        Parsed holder = new Parsed(parsed.row);
        holder.nsPrefix = current.parsed.nsPrefix;
        holder.name = current.parsed.name;
        holder.indent = parsed.indent;
        holder.listItem = true;
        current = current.addChild(new Node(holder));
        parsed.indent += 2;
        parsed.listItem = false;
        return current;
    }

    private Node findParent(Node current, Parsed line) {
        while (line.indent <= current.parsed.indent) {
            current = current.parent;
        }
        return current;
    }

    private static boolean isAttribute(Parsed p) {
        return p.name != null && p.value != null;
    }

    Parsed parseLine(String s) {
        int length;
        if (s == null) {
            return null;
        }
        Parsed parsed = new Parsed(++this.row);
        for (length = s.length(); length > 0 && s.charAt(length - 1) == ' '; --length) {
        }
        int state = 0;
        int start = -1;
        block21: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    if (state != 0) continue block21;
                    ++parsed.indent;
                    continue block21;
                }
                case '\t': {
                    if (state != 0) continue block21;
                    parsed.indent += 2;
                    continue block21;
                }
                case '#': {
                    if (state == 3) {
                        parsed.value = s.substring(start, i - 1).trim();
                        return parsed;
                    }
                    if (state == 1) {
                        throw new ConfigurationReaderException("Invalid comment", Location.of(this.row, i));
                    }
                    return parsed;
                }
                case ':': {
                    if (i + 1 != length && s.charAt(i + 1) != ' ' || state != 1) continue block21;
                    if (start >= 0) {
                        this.parseKey(parsed, s.substring(start, i));
                    }
                    state = 2;
                    continue block21;
                }
                case '~': {
                    if (state == 2 || i + 1 == length) {
                        parsed.value = null;
                        return parsed;
                    }
                }
                case '\\': {
                    if (i + 1 == length) {
                        throw new ConfigurationReaderException("Incomplete escape sequence", Location.of(this.row, i));
                    }
                    ++i;
                    continue block21;
                }
                case '%': {
                    if (i != 0) continue block21;
                    String[] parts = s.split(" ");
                    if (parts.length == 3 && parts[0].equals("%TAG") && parts[1].startsWith("!") && parts[1].endsWith("!")) {
                        if ("!".equals(parts[1])) {
                            this.namespaces.put("", parts[2]);
                        } else {
                            this.namespaces.put(parts[1].substring(1, parts[1].length() - 1), parts[2]);
                        }
                        return parsed;
                    }
                    if (parts.length == 2 && parts[0].equals("%YAML")) {
                        return parsed;
                    }
                    Log.CONFIG.warn("Unknown directive " + s + " at " + Location.of(this.row, i));
                    continue block21;
                }
                case '-': {
                    if (i == 0) {
                        if (!"---".equals(s)) continue block21;
                        return parsed;
                    }
                    if (state != 0) continue block21;
                    parsed.listItem = true;
                    continue block21;
                }
                case '\"': 
                case '\'': {
                    if (state == 0 || state == 2) {
                        int endQuote = s.indexOf(c, i + 1);
                        if (endQuote < 0) {
                            throw new ConfigurationReaderException("Missing closing quote", Location.of(this.row, i));
                        }
                        String v = s.substring(i + 1, endQuote).trim();
                        if (state == 0) {
                            this.parseKey(parsed, v);
                            state = 1;
                        } else {
                            parsed.value = v;
                            state = 4;
                        }
                        i = endQuote;
                        continue block21;
                    }
                }
                default: {
                    if (state == 0) {
                        state = 1;
                        start = i;
                        continue block21;
                    }
                    if (state != 2) continue block21;
                    state = 3;
                    start = i;
                }
            }
        }
        if (state == 1) {
            if (parsed.listItem) {
                if (start > 0) {
                    parsed.value = s.substring(start).trim();
                } else {
                    parsed.value = parsed.name;
                    parsed.name = null;
                }
            } else {
                parsed.value = s.substring(start).trim();
            }
        } else if (state == 3) {
            String val;
            switch (val = s.substring(start).trim()) {
                case "{}": 
                case "null": 
                case "Null": 
                case "NULL": {
                    parsed.value = null;
                    return parsed;
                }
            }
            parsed.value = val;
        }
        return parsed;
    }

    private void parseKey(Parsed p, String s) {
        int colon = s.lastIndexOf(58);
        p.name = colon < 0 ? s : s.substring(colon + 1);
        String string = p.nsPrefix = colon < 0 ? "" : s.substring(0, colon);
        if (!p.nsPrefix.isEmpty()) {
            this.namespaces.putIfAbsent(p.nsPrefix, this.namingStrategy.convert(p.nsPrefix));
        }
    }

    private void readNext() {
        do {
            if (this.lines != null) {
                this.next = this.lines.parsed;
                this.lines = this.lines.next();
                continue;
            }
            this.next = null;
        } while (this.next != null && this.next.name == null && this.next.value == null);
    }

    @Override
    public ConfigurationReader.ElementType nextElement() {
        if (this.next == null) {
            this.readNext();
        }
        this.resetAttributes();
        if (this.next == null) {
            if (this.state.isEmpty()) {
                this.type = ConfigurationReader.ElementType.END_DOCUMENT;
            } else {
                if (this.type == ConfigurationReader.ElementType.END_ELEMENT) {
                    this.state.pop();
                }
                this.type = this.state.isEmpty() ? ConfigurationReader.ElementType.END_DOCUMENT : ConfigurationReader.ElementType.END_ELEMENT;
            }
        } else {
            if (!this.state.isEmpty()) {
                if (this.next.indent < this.state.peek().indent) {
                    if (this.type == ConfigurationReader.ElementType.END_ELEMENT) {
                        this.state.pop();
                    }
                    this.type = ConfigurationReader.ElementType.END_ELEMENT;
                    return this.type;
                }
                if (this.next.indent == this.state.peek().indent) {
                    if (this.type != ConfigurationReader.ElementType.END_ELEMENT) {
                        this.type = ConfigurationReader.ElementType.END_ELEMENT;
                        return this.type;
                    }
                    this.state.pop();
                } else if (this.next.listItem && this.state.peek().listItem) {
                    if (this.type != ConfigurationReader.ElementType.END_ELEMENT) {
                        this.type = ConfigurationReader.ElementType.END_ELEMENT;
                    } else {
                        this.state.peek().value = this.next.value;
                        this.readNext();
                        this.type = ConfigurationReader.ElementType.START_ELEMENT;
                    }
                    return this.type;
                }
            }
            this.state.push(this.next);
            int currentIndent = this.next.indent;
            this.readNext();
            if (this.next != null && this.next.listItem) {
                if (this.next.name == null) {
                    Parsed current = this.state.peek();
                    current.listItem = true;
                    current.value = this.next.value;
                    this.readNext();
                }
            } else {
                while (this.next != null && this.next.indent > currentIndent && this.next.name != null) {
                    if (this.next.value != null) {
                        this.setAttributeValue(this.next.nsPrefix, this.next.name, this.next.value);
                        this.readNext();
                        continue;
                    }
                    if (this.lines == null || !this.lines.parsed.listItem || this.lines.parsed.name != null || this.lines.parsed.value == null) break;
                    String name = this.next.name;
                    String namespace = this.next.nsPrefix;
                    StringBuilder sb = new StringBuilder();
                    this.readNext();
                    while (this.next != null && this.next.listItem) {
                        sb.append(this.replaceProperties(this.next.value)).append(' ');
                        this.readNext();
                    }
                    this.setAttributeValue(namespace, name, sb.toString());
                }
            }
            this.type = ConfigurationReader.ElementType.START_ELEMENT;
        }
        return this.type;
    }

    private void resetAttributes() {
        this.attributeNames.clear();
        this.attributeValues.clear();
        this.attributeNamespaces.clear();
    }

    @Override
    public Location getLocation() {
        return Location.of(this.row, 1);
    }

    @Override
    public String getAttributeName(int index, NamingStrategy strategy) {
        return strategy.convert(this.attributeNames.get(index));
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.namespaces.get(this.attributeNamespaces.get(index));
    }

    @Override
    public String getAttributeValue(String localName, NamingStrategy strategy) {
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            if (!localName.equals(strategy.convert(this.attributeNames.get(i)))) continue;
            return this.attributeValues.get(i);
        }
        return null;
    }

    @Override
    public String getAttributeValue(int index) {
        return this.attributeValues.get(index);
    }

    @Override
    public String getElementText() {
        return this.replaceProperties(this.state.peek().value);
    }

    @Override
    public String getLocalName(NamingStrategy strategy) {
        return strategy.convert(this.state.peek().name);
    }

    @Override
    public String getNamespace() {
        return this.namespaces.get(this.state.peek().nsPrefix);
    }

    @Override
    public boolean hasNext() {
        if (!this.state.isEmpty()) {
            return true;
        }
        if (this.next == null) {
            this.readNext();
        }
        return this.next != null;
    }

    @Override
    public int getAttributeCount() {
        return this.attributeNames.size();
    }

    @Override
    public Map.Entry<String, String> getMapItem(String nameAttribute) {
        String name = this.getLocalName(NamingStrategy.IDENTITY);
        this.nextElement();
        String type = this.getLocalName();
        return new SimpleImmutableEntry<String, String>(name, type);
    }

    @Override
    public void endMapItem() {
        this.nextElement();
    }

    @Override
    public String[] readArray(String outer, String inner) {
        boolean loop;
        this.require(ConfigurationReader.ElementType.START_ELEMENT, null, outer);
        ArrayList<String> elements = new ArrayList<String>();
        do {
            elements.add(this.getElementText());
            this.nextElement();
            this.require(ConfigurationReader.ElementType.END_ELEMENT, null, outer);
            loop = this.next.listItem;
            if (!loop) continue;
            this.nextElement();
        } while (loop);
        return elements.toArray(new String[0]);
    }

    @Override
    public void require(ConfigurationReader.ElementType type, String namespace, String name) {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getLocalName())) {
            throw new ConfigurationReaderException("Expected event " + type + (String)(name != null ? " with name '" + name + "'" : "") + (namespace != null && name != null ? " and" : "") + (String)(namespace != null ? " with namespace '" + namespace + "'" : "") + " but got" + (String)(type != this.type ? " " + this.type : "") + (String)(name != null && this.getLocalName() != null && !name.equals(this.getLocalName()) ? " name '" + this.getLocalName() + "'" : "") + (namespace != null && name != null && this.getLocalName() != null && !name.equals(this.getLocalName()) && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " and" : "") + (String)(namespace != null && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " namespace '" + this.getNamespace() + "'" : ""), Location.of(this.row, 1));
        }
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        return false;
    }

    @Override
    public void close() {
        Util.close((AutoCloseable)this.reader);
    }

    @Override
    public void setAttributeValue(String namespace, String name, String value) {
        this.attributeNames.add(name);
        this.attributeNamespaces.add(namespace);
        this.attributeValues.add(this.replaceProperties(value));
    }

    public Map<String, Object> asMap() {
        return Collections.singletonMap(this.lines.parsed.name, this.asMap(this.lines));
    }

    private Object asMap(Node node) {
        if (node.hasChildren()) {
            if (node.children.get((int)0).parsed.listItem) {
                ArrayList<Object> children = new ArrayList<Object>(node.children.size());
                for (Node child : node.children) {
                    children.add(this.asMap(child));
                }
                return children;
            }
            LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>(node.children.size());
            for (Node child : node.children) {
                children.put(child.parsed.name, this.asMap(child));
            }
            return children;
        }
        return node.parsed.value;
    }

    public static class Parsed {
        final int row;
        int indent;
        boolean listItem;
        boolean list;
        String name;
        String nsPrefix;
        String value;

        public Parsed(int row) {
            this.row = row;
        }

        public String toString() {
            return "Parsed{row=" + this.row + ", indent=" + this.indent + ", list=" + this.list + ", listItem=" + this.listItem + ", name='" + this.name + "', nsPrefix='" + this.nsPrefix + "', value='" + this.value + "'}";
        }
    }

    private static class Node {
        final Parsed parsed;
        ArrayList<Node> children;
        Node parent;

        Node(Parsed parsed) {
            this.parsed = parsed;
        }

        Node addChild(Node child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            if (YamlConfigurationReader.isAttribute(child.parsed)) {
                for (int i = 0; i < this.children.size(); ++i) {
                    if (YamlConfigurationReader.isAttribute(this.children.get((int)i).parsed)) continue;
                    this.children.add(i, child);
                    child.parent = this;
                    return child;
                }
            }
            this.children.add(child);
            child.parent = this;
            return child;
        }

        Node addSibling(Node sibling) {
            this.parent.addChild(sibling);
            return sibling;
        }

        Node next() {
            if (this.hasChildren()) {
                return this.children.remove(0);
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.next();
        }

        public String toString() {
            return this.parsed.toString();
        }

        boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }
    }
}

