/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.liquibase.logging.slf4j;

import java.util.logging.Level;
import liquibase.logging.LogMessageFilter;
import liquibase.logging.core.AbstractLogger;
import org.slf4j.Logger;

public class Slf4jLogger
extends AbstractLogger {
    private static final int TRACE_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_THRESHOLD = Level.WARNING.intValue();
    private final Logger logger;

    Slf4jLogger(Logger logger, LogMessageFilter filter) {
        super(filter);
        this.logger = logger;
    }

    public void log(Level level, String message, Throwable e) {
        String filteredMessage = this.filterMessage(message);
        int levelValue = level.intValue();
        if (levelValue <= TRACE_THRESHOLD) {
            this.logger.trace(filteredMessage, e);
        } else if (levelValue <= DEBUG_THRESHOLD) {
            this.logger.debug(filteredMessage, e);
        } else if (levelValue <= INFO_THRESHOLD) {
            this.logger.info(filteredMessage, e);
        } else if (levelValue <= WARN_THRESHOLD) {
            this.logger.warn(filteredMessage, e);
        } else {
            this.logger.error(filteredMessage, e);
        }
    }

    public void severe(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.filterMessage(message));
        }
    }

    public void severe(String message, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.filterMessage(message), e);
        }
    }

    public void warning(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.filterMessage(message));
        }
    }

    public void warning(String message, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.filterMessage(message), e);
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.filterMessage(message));
        }
    }

    public void info(String message, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.filterMessage(message), e);
        }
    }

    public void config(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.filterMessage(message));
        }
    }

    public void config(String message, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.filterMessage(message), e);
        }
    }

    public void fine(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.filterMessage(message));
        }
    }

    public void fine(String message, Throwable e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.filterMessage(message), e);
        }
    }
}

