/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.configuration.central.deploy.converter.HoconDurationConverter$;
import ai.digital.deploy.sql.model.WorkerInfo;
import akka.actor.ActorRef;
import akka.actor.AddressFromURIString$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.spring.BeanWrapper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u000b\u0016\u0001\tB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A\u0011\r\u0001B\u0001B\u0003%Q\r\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bA\u0011\"!\b\u0001\u0005\u0004%Y!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA\u0011\"a\f\u0001\u0005\u0004%\t!!\r\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003gA\u0011\"!\u0019\u0001\u0001\u0004%\t!a\u0019\t\u0013\u0005E\u0004\u00011A\u0005\u0002\u0005M\u0004\u0002CAA\u0001\u0001\u0006K!!\u001a\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u00111\u0014\u0001\u0005B\u0005u\u0005bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\tY\r\u0001C!\u0003\u001bDq!!5\u0001\t\u0003\n\u0019\u000eC\u0004\u0002V\u0002!\t%a6\u0003\u001f]{'o[3sgJ+7o\\;sG\u0016T!AF\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u00193\u0005!!/Z:u\u0015\tQ2$\u0001\u0003d_J,'B\u0001\u000f\u001e\u0003!!W\r\u001d7ps&$(B\u0001\u0010 \u0003%AXMY5bY\u0006\u00147OC\u0001!\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011%\u000b\u0018\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019:\u0012aB:fGV\u0014X\rZ\u0005\u0003Q\u0015\u0012q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005)bS\"A\u0016\u000b\u0005YI\u0012BA\u0017,\u000599vN]6feN\u001cVM\u001d<jG\u0016\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000bMdg\r\u000e6\u000b\u0003M\n\u0001b\u001a:jujdW\rZ\u0005\u0003kA\u0012q\u0001T8hO&tw-A\u0007x_J\\WM]'b]\u0006<WM\u001d\t\u0004qmjT\"A\u001d\u000b\u0005iZ\u0012AB:qe&tw-\u0003\u0002=s\tY!)Z1o/J\f\u0007\u000f]3s!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0003bGR|'OC\u0001C\u0003\u0011\t7n[1\n\u0005\u0011{$\u0001C!di>\u0014(+\u001a4)\u0005\u00051\u0005CA$S\u001b\u0005A%BA%K\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u00172\u000bqAZ1di>\u0014\u0018P\u0003\u0002N\u001d\u0006)!-Z1og*\u0011q\nU\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011+A\u0002pe\u001eL!a\u0015%\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\u0006B\u0001V1f\u0003\"a\u0012,\n\u0005]C%!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00051\u0014\u0001E<pe.,'OU3q_NLGo\u001c:z!\ta&-D\u0001^\u0015\tqv,\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002\u0017A*\u0011\u0011mG\u0001\u0007K:<\u0017N\\3\n\u0005\rl&!\b+bg.,\u00050Z2vi&|gnV8sW\u0016\u0014(+\u001a9pg&$xN]=)\u0005\t1\u0005c\u0001\u001d<MB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eY\u0001\u0007i\u0006\u001c8.\u001a:\n\u0005-D'a\u0005+bg.,\u00050Z2vi&|g.\u00128hS:,\u0007FA\u0002G\u0003)\t7o\u001b+j[\u0016|W\u000f\u001e\t\u0003_bt!\u0001\u001d<\u0011\u0005E$X\"\u0001:\u000b\u0005M\f\u0013A\u0002\u001fs_>$hHC\u0001v\u0003\u0015\u00198-\u00197b\u0013\t9H/\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<uQ\u0011!A\u0010W@\u0011\u0005\u001dk\u0018B\u0001@I\u0005\u00151\u0016\r\\;fC\t\t\t!\u0001\u0012%wbdg\u0006^1tW\u0016\u0014h&Y:l)&lWm\\;uuE\u0002\u0004e]3d_:$7/`\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u001d\u00111BA\t\u0003+\tI\u0002E\u0002\u0002\n\u0001i\u0011!\u0006\u0005\u0006m\u0015\u0001\ra\u000e\u0015\u0004\u0003\u00171\u0005&BA\u0006+bK\u0006\"\u0002.\u0006\u0001\u0004Y\u0006fAA\t\r\")\u0011-\u0002a\u0001K\"\u001a\u0011Q\u0003$\t\u000b5,\u0001\u0019\u00018)\u000b\u0005eA\u0010W@\u0002\u000fQLW.Z8viV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE!\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\t)CA\u0004US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\nA\u0002\u001b;uaJ+7\u000f]8og\u0016,\"!a\r\u0011\t\u0005U\u00121I\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005\u00191\u000f]5\u000b\t\u0005u\u0012qH\u0001\te\u0016\u001cH/Z1ts*\u0019\u0011\u0011\t)\u0002\u000b)\u0014wn]:\n\t\u0005\u0015\u0013q\u0007\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\u000eQR$\bOU3ta>t7/\u001a\u0011)\u0007%\tY\u0005\u0005\u0003\u0002N\u0005uSBAA(\u0015\rQ\u0012\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0002sg*!\u0011qKA-\u0003\t98O\u0003\u0002\u0002\\\u0005)!.\u0019<bq&!\u0011qLA(\u0005\u001d\u0019uN\u001c;fqR\f1B]8mKN+'O^5dKV\u0011\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N\u000e\u0002\u0011M,7-\u001e:jifLA!a\u001c\u0002j\tY!k\u001c7f'\u0016\u0014h/[2f\u0003=\u0011x\u000e\\3TKJ4\u0018nY3`I\u0015\fH\u0003BA;\u0003{\u0002B!a\u001e\u0002z5\tA/C\u0002\u0002|Q\u0014A!\u00168ji\"I\u0011qP\u0006\u0002\u0002\u0003\u0007\u0011QM\u0001\u0004q\u0012\n\u0014\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0003F\u0001\u0007G\u0003=\u0019\b.\u001e;e_^twk\u001c:lKJ\u001cH\u0003BA;\u0003\u0013Cq!a#\u000e\u0001\u0004\ti)A\u0004x_J\\WM]:\u0011\u000b\u0005=\u0015q\u00138\u000e\u0005\u0005E%\u0002BA\u0014\u0003'S!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000b\tJ\u0001\u0003MSN$\u0018AD:ikR$wn\u001e8X_J\\WM\u001d\u000b\u0005\u0003k\ny\nC\u0004\u0002\":\u0001\r!a)\u0002\u0011]|'o[3s\u0013\u0012\u0004B!!*\u0002,6\u0011\u0011q\u0015\u0006\u0005\u0003S\u000b\u0019*\u0001\u0003mC:<\u0017\u0002BAW\u0003O\u0013q!\u00138uK\u001e,'/A\u0007jg2{7-\u00197X_J\\WM\u001d\u000b\u0005\u0003g\u000bI\f\u0005\u0003\u0002x\u0005U\u0016bAA\\i\n9!i\\8mK\u0006t\u0007BBA^\u001f\u0001\u0007a.A\u0004bI\u0012\u0014Xm]:\u0002+QD'o\\<M_\u000e\fGnV8sW\u0016\u0014XI\u001d:peR!\u0011\u0011YAd!\u0011\t9(a1\n\u0007\u0005\u0015GOA\u0004O_RD\u0017N\\4\t\r\u0005%\u0007\u00031\u0001o\u0003\u0005\u0019\u0018\u0001\u0004:f[>4XmV8sW\u0016\u0014H\u0003BA;\u0003\u001fDq!!)\u0012\u0001\u0004\t\u0019+\u0001\u000bsKJ,w-[:uKJ<\u0005n\\:u)\u0006\u001c8n\u001d\u000b\u0003\u0003\u001b\u000b1\u0002\\5ti^{'o[3sgR1\u0011\u0011\\A|\u0005\u000f\u0001b!a$\u0002\u0018\u0006m\u0007\u0003BAo\u0003gl!!a8\u000b\t\u0005\u0005\u00181]\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003K\f9/A\u0002tc2TA!!;\u0002l\u00061A-\u001a9m_fTA!!<\u0002p\u00069A-[4ji\u0006d'BAAy\u0003\t\t\u0017.\u0003\u0003\u0002v\u0006}'AC,pe.,'/\u00138g_\"9\u0011\u0011`\nA\u0002\u0005m\u0018A\u00029bO&tw\r\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\r\u0011\taX\u0001\u0004IR|\u0017\u0002\u0002B\u0003\u0003\u007f\u0014a\u0001U1hS:<\u0007b\u0002B\u0005'\u0001\u0007!1B\u0001\u0006_J$WM\u001d\t\u0005\u0003{\u0014i!\u0003\u0003\u0003\u0010\u0005}(\u0001C(sI\u0016\u0014\u0018N\\4)\u0007\u0001\u0011\u0019\u0002\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\r\u0011IBT\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B\u000f\u0005/\u0011!bQ8oiJ|G\u000e\\3s\u0001")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final BeanWrapper<ActorRef> workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    @Autowired
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    @Autowired
    private RoleService roleService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable)() -> "Shutting down workers " + workers + ".");
        }
        CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().find((Function1 & Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable)s -> this.throwLocalWorkerError((String)s));
        this.workerRepository.listWorkers().map((Function1 & Serializable)x$1 -> (Worker)x$1._1()).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$12 = new WorkerManager.messages$.ShutdownWorker(CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().toList(), true);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$12);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$12, x$2, x$3), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable)() -> "Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.");
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException("Workers " + CollectionConverters$.MODULE$.ListHasAsScala(notFound).asScala().mkString("[", ", ", "]") + " not found. (Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.)");
            }
            return;
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Worker for id " + workerId + " not found.");
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException("Local worker (" + s + ") cannot be shutdown.");
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Worker for id " + workerId + " not found.");
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<String> reregisterGhostTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return ((TaskExecutionEngine)this.engine.get()).reregisterGhostTasks();
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        if (!this.hasPermission(PlatformPermissions.ADMIN) && !this.roleService().isReadOnlyAdmin()) {
            throw PermissionDeniedException.forPermission((Permission)PlatformPermissions.ADMIN, (String)"");
        }
        Timeout timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.FetchWorkers x$1 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$22 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3), (Duration)timeout.duration());
        List workers = this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))));
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava().stream().collect(Collectors.toList());
        }
        PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
        int from = (paging.page() - 1) * paging.resultsPerPage();
        int to = from + paging.resultsPerPage() <= CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size() ? from + paging.resultsPerPage() : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to)).asJava();
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        if (workers$1.isEmpty() || workers$1.contains(worker.address())) {
            $this.workerRepository.removeTasks(worker.id());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$1 = new WorkerManager.messages$.ShutdownWorker((List)new .colon.colon((Object)address, (List)Nil$.MODULE$), false);
        Timeout x$2 = $this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable)() -> "Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.");
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException("Worker " + address + " not found.");
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$3;
        Timeout x$2;
        WorkerManager.messages$.FetchWorkers x$1;
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new WorkerManager.messages$.FetchWorkers()), x$2 = $this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((IterableOnce)response.healthy());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException("Worker for id " + workerId$2 + " is still active, cannot be removed.");
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        if (healthy.contains((Object)w.address())) {
            return WorkerState$.MODULE$.CONNECTED();
        }
        if (incompatible.contains((Object)w.address())) {
            return WorkerState$.MODULE$.INCOMPATIBLE();
        }
        if (draining.contains((Object)w.address())) {
            return WorkerState$.MODULE$.DRAINING();
        }
        return WorkerState$.MODULE$.DISCONNECTED();
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") BeanWrapper<ActorRef> workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired BeanWrapper<TaskExecutionEngine> engine, @Value(value="${xl.tasker.askTimeout:10 seconds}") String askTimeout) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        this.engine = engine;
        Logging.$init$((Logging)this);
        this.timeout = new Timeout(HoconDurationConverter$.MODULE$.convert(askTimeout));
        this.httpResponse = null;
        this.roleService = null;
    }
}

