/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbunit.dataset.datatype.BytesDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class UuidAwareBytesDataType
extends BytesDataType {
    private static final Pattern UUID_RE = Pattern.compile("uuid'([0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12})'");

    UuidAwareBytesDataType(String name, int sqlType) {
        super(name, sqlType);
    }

    @Override
    public Object typeCast(Object value) throws TypeCastException {
        return super.typeCast(UuidAwareBytesDataType.uuidAwareValueOf(value));
    }

    private static Object uuidAwareValueOf(Object value) {
        String s;
        Matcher m;
        if (value instanceof String && (m = UUID_RE.matcher(s = (String)value)).find()) {
            UUID uuid = UUID.fromString(m.group(1));
            return UuidAwareBytesDataType.uuidToBytes(uuid);
        }
        return value;
    }

    private static byte[] uuidToBytes(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        return new byte[]{UuidAwareBytesDataType.extractByte(msb, 0), UuidAwareBytesDataType.extractByte(msb, 1), UuidAwareBytesDataType.extractByte(msb, 2), UuidAwareBytesDataType.extractByte(msb, 3), UuidAwareBytesDataType.extractByte(msb, 4), UuidAwareBytesDataType.extractByte(msb, 5), UuidAwareBytesDataType.extractByte(msb, 6), UuidAwareBytesDataType.extractByte(msb, 7), UuidAwareBytesDataType.extractByte(lsb, 0), UuidAwareBytesDataType.extractByte(lsb, 1), UuidAwareBytesDataType.extractByte(lsb, 2), UuidAwareBytesDataType.extractByte(lsb, 3), UuidAwareBytesDataType.extractByte(lsb, 4), UuidAwareBytesDataType.extractByte(lsb, 5), UuidAwareBytesDataType.extractByte(lsb, 6), UuidAwareBytesDataType.extractByte(lsb, 7)};
    }

    private static byte extractByte(long value, int byteIndex) {
        return (byte)(value >> 56 - byteIndex * 8 & 0xFFL);
    }
}

