/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TagFilter;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModGeneratedColumnsStatementNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class UpdateNode
extends DMLModGeneratedColumnsStatementNode {
    int[] changedColumnIds;
    boolean deferred;
    ValueNode checkConstraints;
    protected FromTable targetTable;
    protected FormatableBitSet readColsBitSet;
    protected boolean positionedUpdate;
    static final String COLUMNNAME = "###RowLocationToUpdate";

    UpdateNode(TableName tableName, ResultSetNode resultSetNode, MatchingClauseNode matchingClauseNode, ContextManager contextManager) {
        super(resultSetNode, matchingClauseNode, contextManager);
        this.targetTableName = tableName;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "UPDATE";
    }

    @Override
    void printSubNodes(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        int n;
        QueryTreeNode queryTreeNode2;
        boolean bl;
        Object object;
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        TableName tableName = null;
        CurrentOfNode currentOfNode = null;
        ResultColumnList resultColumnList = null;
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null && (object = this.resolveTableToSynonym(this.targetTableName)) != null) {
            this.synonymTableName = this.targetTableName;
            this.targetTableName = object;
        }
        if (this.inMatchingClause()) {
            this.tagOriginalResultSetColumns();
        }
        object = this.getExplicitlySetColumns();
        List<CastNode> list = this.collectAllCastNodes();
        this.tagPrivilegedNodes();
        TagFilter tagFilter = new TagFilter("updatePrivs");
        this.getCompilerContext().addPrivilegeFilter(tagFilter);
        this.bindTables(dataDictionary);
        SelectNode selectNode = (SelectNode)this.resultSet;
        this.targetTable = (FromTable)selectNode.fromList.elementAt(0);
        if (this.targetTable instanceof CurrentOfNode) {
            this.positionedUpdate = true;
            currentOfNode = (CurrentOfNode)this.targetTable;
            tableName = currentOfNode.getBaseCursorTargetTableName();
        }
        if (this.targetTable instanceof FromVTI) {
            this.targetVTI = (FromVTI)this.targetTable;
            this.targetVTI.setTarget();
        } else if (this.targetTableName == null) {
            this.targetTableName = tableName;
        } else if (tableName != null && !this.targetTableName.equals(tableName)) {
            throw StandardException.newException("42X29", this.targetTableName, currentOfNode.getCursorName());
        }
        this.verifyTargetTable();
        this.addUpdatePriv((ArrayList<String>)object);
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        ColumnDescriptorList columnDescriptorList2 = new ColumnDescriptorList();
        this.addGeneratedColumns(this.targetTableDescriptor, this.resultSet, columnDescriptorList2, columnDescriptorList);
        this.resultSet.getResultColumns().markUpdated();
        if (this.synonymTableName != null) {
            this.normalizeSynonymColumns(this.resultSet.getResultColumns(), this.targetTable);
        }
        this.normalizeCorrelatedColumns(this.resultSet.getResultColumns(), this.targetTable);
        this.resultSet.bindResultColumns(this.targetTableDescriptor, this.targetVTI, this.resultSet.getResultColumns(), this, fromList);
        this.forbidGenerationOverrides(this.resultSet.getResultColumns(), columnDescriptorList);
        if (dataDictionary.checkVersion(230, null)) {
            this.resultSet.getResultColumns().replaceOrForbidDefaults(this.targetTableDescriptor, this.resultSet.getResultColumns(), true);
            this.resultSet.getResultColumns().checkForInvalidDefaults();
            this.resultSet.getResultColumns().forbidOverrides(this.resultSet.getResultColumns());
        } else {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            if (!languageConnectionContext.getAutoincrementUpdate()) {
                this.resultSet.getResultColumns().forbidOverrides(null);
            }
        }
        boolean bl2 = false;
        if (this.targetTable instanceof FromBaseTable) {
            ((FromBaseTable)this.targetTable).markUpdated(this.resultSet.getResultColumns());
        } else if (this.targetTable instanceof FromVTI || this.targetTable instanceof FromSubquery) {
            this.resultColumnList = this.resultSet.getResultColumns();
        } else {
            ExecPreparedStatement execPreparedStatement = currentOfNode.getCursorStatement();
            if (!execPreparedStatement.hasUpdateColumns()) {
                this.getResultColumnList();
                resultColumnList = this.resultSet.getResultColumns().expandToAll(this.targetTableDescriptor, this.targetTable.getTableName());
                this.getAffectedIndexes(this.targetTableDescriptor, null, null);
                bl2 = true;
            } else {
                this.resultSet.getResultColumns().checkColumnUpdateability(execPreparedStatement, currentOfNode.getCursorName());
            }
        }
        this.changedColumnIds = this.getChangedColumnIds(this.resultSet.getResultColumns());
        boolean bl3 = bl = this.targetVTI == null || this.inMatchingClause();
        if (!bl2 && bl) {
            this.getCompilerContext().pushCurrentPrivType(-1);
            try {
                int n2;
                this.readColsBitSet = new FormatableBitSet();
                queryTreeNode2 = this.getResultColumnList(this.resultSet.getResultColumns());
                resultColumnList = this.resultSet.getResultColumns().copyListAndObjects();
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor, resultColumnList, columnDescriptorList2);
                resultColumnList = ((FromBaseTable)queryTreeNode2).addColsToList(resultColumnList, this.readColsBitSet);
                this.resultColumnList = ((FromBaseTable)queryTreeNode2).addColsToList(this.resultColumnList, this.readColsBitSet);
                n = this.targetTableDescriptor.getMaxColumnID();
                for (n2 = 1; n2 <= n && this.readColsBitSet.get(n2); ++n2) {
                }
                if (n2 > n) {
                    this.readColsBitSet = null;
                }
            }
            finally {
                this.getCompilerContext().popCurrentPrivType();
            }
        }
        if (bl) {
            this.resultColumnList.appendResultColumns(resultColumnList, false);
            queryTreeNode2 = new CurrentRowLocationNode(this.getContextManager());
        } else {
            queryTreeNode2 = new NumericConstantNode(TypeId.getBuiltInTypeId(4), 0, this.getContextManager());
        }
        ResultColumn resultColumn = new ResultColumn(COLUMNNAME, (ValueNode)queryTreeNode2, this.getContextManager());
        resultColumn.markGenerated();
        this.resultColumnList.addResultColumn(resultColumn);
        this.checkTableNameAndScrubResultColumns(this.resultColumnList);
        this.resultSet.setResultColumns(this.resultColumnList);
        if (this.inMatchingClause()) {
            this.associateAddedColumns();
        }
        SelectNode.checkNoWindowFunctions(this.resultSet, "<update source>");
        super.bindExpressions();
        this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
        resultColumn.bindResultColumnToExpression();
        this.resultColumnList.checkStorableExpressions();
        if (!this.resultColumnList.columnTypesAndLengthsMatch()) {
            this.resultSet = new NormalizeResultSetNode(this.resultSet, this.resultColumnList, null, true, this.getContextManager());
            if (this.hasCheckConstraints(dataDictionary, this.targetTableDescriptor) || this.hasGenerationClauses(this.targetTableDescriptor)) {
                n = resultColumnList.size();
                resultColumnList = new ResultColumnList(this.getContextManager());
                ResultColumnList queryTreeNode3 = this.resultSet.getResultColumns();
                for (int i = 0; i < n; ++i) {
                    resultColumnList.addElement((ResultColumn)queryTreeNode3.elementAt(i + n));
                }
            }
        }
        if (null != this.targetVTI && !this.inMatchingClause()) {
            this.deferred = VTIDeferModPolicy.deferIt(2, this.targetVTI, this.resultColumnList.getColumnNames(), selectNode.getWhereClause());
        } else {
            n = this.getAllRelevantTriggers(dataDictionary, this.targetTableDescriptor, this.changedColumnIds, true).size() > 0 ? 1 : 0;
            ResultColumnList resultColumnList2 = n != 0 ? this.resultColumnList : resultColumnList;
            this.parseAndBindGenerationClauses(dataDictionary, this.targetTableDescriptor, resultColumnList, this.resultColumnList, true, this.resultSet);
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getOptimizerFactory(), this.targetTableDescriptor, null, resultColumnList2, this.changedColumnIds, this.readColsBitSet, true, new boolean[1]);
            if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
            }
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            this.autoincRowLocation = dataDictionary.computeAutoincRowLocations(transactionController, this.targetTableDescriptor);
        }
        this.identitySequenceUUIDString = this.getUUIDofSequenceGenerator();
        this.getCompilerContext().popCurrentPrivType();
        this.getCompilerContext().removePrivilegeFilter(tagFilter);
        for (CastNode castNode : list) {
            this.addUDTUsagePriv(castNode);
        }
    }

    @Override
    int getPrivType() {
        return 1;
    }

    private ArrayList<String> getExplicitlySetColumns() throws StandardException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        for (int i = 0; i < resultColumnList.size(); ++i) {
            arrayList.add(((ResultColumn)resultColumnList.elementAt(i)).getName());
        }
        return arrayList;
    }

    private void associateAddedColumns() throws StandardException {
        for (ColumnReference columnReference : this.collectAllResultSetColumns()) {
            if (columnReference.taggedWith("origUpdateCol")) continue;
            columnReference.setMergeTableID(2);
        }
    }

    private void tagOriginalResultSetColumns() throws StandardException {
        for (ColumnReference columnReference : this.collectAllResultSetColumns()) {
            columnReference.addTag("origUpdateCol");
        }
    }

    private List<ColumnReference> collectAllResultSetColumns() throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.resultSet.getResultColumns().accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    private List<CastNode> collectAllCastNodes() throws StandardException {
        CollectNodesVisitor<CastNode> collectNodesVisitor = new CollectNodesVisitor<CastNode>(CastNode.class);
        ValueNode valueNode = ((SelectNode)this.resultSet).whereClause;
        if (valueNode != null) {
            valueNode.accept(collectNodesVisitor);
        }
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        for (int i = 0; i < resultColumnList.size(); ++i) {
            ((ResultColumn)resultColumnList.elementAt(i)).getExpression().accept(collectNodesVisitor);
        }
        return collectNodesVisitor.getList();
    }

    private void tagPrivilegedNodes() throws StandardException {
        ArrayList<QueryTreeNode> arrayList = new ArrayList<QueryTreeNode>();
        SelectNode selectNode = (SelectNode)this.resultSet;
        arrayList.add(this);
        ValueNode valueNode = selectNode.whereClause;
        if (valueNode != null) {
            this.collectPrivilegedNodes(arrayList, valueNode);
        }
        ResultColumnList resultColumnList = this.resultSet.getResultColumns();
        for (int i = 0; i < resultColumnList.size(); ++i) {
            this.collectPrivilegedNodes(arrayList, ((ResultColumn)resultColumnList.elementAt(i)).getExpression());
        }
        for (QueryTreeNode queryTreeNode : arrayList) {
            queryTreeNode.addTag("updatePrivs");
        }
    }

    private void collectPrivilegedNodes(ArrayList<QueryTreeNode> arrayList, QueryTreeNode queryTreeNode) throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        queryTreeNode.accept(collectNodesVisitor);
        arrayList.addAll(collectNodesVisitor.getList());
        CollectNodesVisitor<StaticMethodCallNode> collectNodesVisitor2 = new CollectNodesVisitor<StaticMethodCallNode>(StaticMethodCallNode.class);
        queryTreeNode.accept(collectNodesVisitor2);
        arrayList.addAll(collectNodesVisitor2.getList());
        CollectNodesVisitor<FromBaseTable> collectNodesVisitor3 = new CollectNodesVisitor<FromBaseTable>(FromBaseTable.class);
        queryTreeNode.accept(collectNodesVisitor3);
        arrayList.addAll(collectNodesVisitor3.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdatePriv(ArrayList<String> arrayList) throws StandardException {
        if (!this.isPrivilegeCollectionRequired()) {
            return;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.pushCurrentPrivType(1);
        try {
            for (String string : arrayList) {
                ColumnDescriptor columnDescriptor = this.targetTableDescriptor.getColumnDescriptor(string);
                compilerContext.addRequiredColumnPriv(columnDescriptor);
            }
        }
        finally {
            compilerContext.popCurrentPrivType();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor;
        if (!this.deferred && !this.inMatchingClause() && (conglomerateDescriptor = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && conglomerateDescriptor.isIndex()) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(nArray)) {
                this.deferred = true;
            }
        }
        if (null == this.targetTableDescriptor) {
            return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(2, this.deferred, this.changedColumnIds);
        }
        int n = this.inMatchingClause() ? 6 : this.resultSet.updateTargetLockMode();
        long l = this.targetTableDescriptor.getHeapConglomerateId();
        TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
        StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
        for (int i = 0; i < staticCompiledOpenConglomInfoArray.length; ++i) {
            staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
        }
        if (this.targetTableDescriptor.getLockGranularity() == 'T') {
            n = 7;
        }
        return this.getGenericConstantActionFactory().getUpdateConstantAction(this.targetTableDescriptor, transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.indexNames, this.deferred, this.targetTableDescriptor.getUUID(), n, false, this.changedColumnIds, null, null, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), UpdateNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), this.positionedUpdate, this.resultSet.isOneRowResultSet(), this.autoincRowLocation, this.inMatchingClause(), this.identitySequenceUUIDString);
    }

    protected void setDeferredForUpdateOfIndexColumn() {
        ConglomerateDescriptor conglomerateDescriptor;
        if (!this.deferred && (conglomerateDescriptor = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && conglomerateDescriptor.isIndex()) {
            int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(nArray)) {
                this.deferred = true;
            }
        }
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCodeForTemporaryTable(activationClassBuilder);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", activationClassBuilder.newRowLocationScanResultSetName());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        if (this.inMatchingClause()) {
            this.matchingClause.generateResultSetField(activationClassBuilder, methodBuilder);
        } else {
            this.resultSet.generate(activationClassBuilder, methodBuilder);
        }
        if (null != this.targetVTI && !this.inMatchingClause()) {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            methodBuilder.callMethod((short)185, null, "getUpdateVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
        } else {
            this.generateGenerationClauses(this.resultColumnList, this.resultSet.getResultSetNumber(), true, activationClassBuilder, methodBuilder);
            this.generateCheckConstraints(this.checkConstraints, activationClassBuilder, methodBuilder);
            if (this.isDependentTable) {
                methodBuilder.push(activationClassBuilder.addItem(this.makeConstantAction()));
                methodBuilder.push(activationClassBuilder.addItem(this.makeResultDescription()));
                methodBuilder.callMethod((short)185, null, "getDeleteCascadeUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 5);
            } else {
                methodBuilder.callMethod((short)185, null, "getUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 3);
            }
        }
    }

    @Override
    protected final int getStatementType() {
        return 3;
    }

    FormatableBitSet getReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, ColumnDescriptorList columnDescriptorList) throws StandardException {
        boolean[] blArray = new boolean[]{this.requiresDeferredProcessing()};
        ArrayList<ConglomerateDescriptor> arrayList = new ArrayList<ConglomerateDescriptor>();
        this.relevantCdl = new ConstraintDescriptorList();
        this.relevantTriggers = new TriggerDescriptorList();
        FormatableBitSet formatableBitSet = UpdateNode.getUpdateReadMap(dataDictionary, tableDescriptor, resultColumnList, arrayList, this.relevantCdl, this.relevantTriggers, blArray, columnDescriptorList);
        this.markAffectedIndexes(arrayList);
        this.adjustDeferredFlag(blArray[0]);
        return formatableBitSet;
    }

    private int[] getChangedColumnIds(ResultColumnList resultColumnList) {
        if (resultColumnList == null) {
            return null;
        }
        return resultColumnList.sortMe();
    }

    static FormatableBitSet getUpdateReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, List<ConglomerateDescriptor> list, ConstraintDescriptorList constraintDescriptorList, TriggerDescriptorList triggerDescriptorList, boolean[] blArray, ColumnDescriptorList columnDescriptorList) throws StandardException {
        Object object;
        int n;
        int n2;
        int n3 = tableDescriptor.getMaxColumnID();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3 + 1);
        int[] nArray = resultColumnList.sortMe();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            formatableBitSet.set(nArray[n2]);
        }
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, resultColumnList, formatableBitSet, list);
        tableDescriptor.getAllRelevantConstraints(3, nArray, blArray, constraintDescriptorList);
        n2 = constraintDescriptorList.size();
        for (n = 0; n < n2; ++n) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(n);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            object = ((CheckConstraintDescriptor)constraintDescriptor).getReferencedColumns();
            for (int i = 0; i < ((int[])object).length; ++i) {
                formatableBitSet.set(object[i]);
            }
        }
        UpdateNode.addGeneratedColumnPrecursors(tableDescriptor, columnDescriptorList, formatableBitSet);
        tableDescriptor.getAllRelevantTriggers(3, nArray, triggerDescriptorList);
        if (triggerDescriptorList.size() > 0) {
            blArray[0] = true;
            n = 0;
            boolean bl = dataDictionary.checkVersion(210, null);
            object = triggerDescriptorList.iterator();
            while (object.hasNext()) {
                TriggerDescriptor triggerDescriptor = (TriggerDescriptor)object.next();
                if (bl) {
                    int n4;
                    int[] nArray2 = triggerDescriptor.getReferencedColsInTriggerAction();
                    int[] nArray3 = triggerDescriptor.getReferencedCols();
                    if (nArray3 == null || nArray3.length == 0) {
                        for (n4 = 0; n4 < n3; ++n4) {
                            formatableBitSet.set(n4 + 1);
                        }
                        break;
                    }
                    if (nArray2 == null || nArray2.length == 0) {
                        if (!triggerDescriptor.getReferencingNew() && !triggerDescriptor.getReferencingOld()) {
                            for (n4 = 0; n4 < nArray3.length; ++n4) {
                                formatableBitSet.set(nArray3[n4]);
                            }
                            continue;
                        }
                        n = 1;
                        break;
                    }
                    for (n4 = 0; n4 < nArray3.length; ++n4) {
                        formatableBitSet.set(nArray3[n4]);
                    }
                    for (n4 = 0; n4 < nArray2.length; ++n4) {
                        formatableBitSet.set(nArray2[n4]);
                    }
                    continue;
                }
                if (!triggerDescriptor.getReferencingNew() && !triggerDescriptor.getReferencingOld()) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                for (int i = 1; i <= n3; ++i) {
                    formatableBitSet.set(i);
                }
            }
        }
        return formatableBitSet;
    }

    private static void addGeneratedColumnPrecursors(TableDescriptor tableDescriptor, ColumnDescriptorList columnDescriptorList, FormatableBitSet formatableBitSet) throws StandardException {
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            String[] stringArray = columnDescriptor.getDefaultInfo().getReferencedColumnNames();
            int[] nArray = tableDescriptor.getColumnIDs(stringArray);
            int n2 = nArray.length;
            for (int j = 0; j < n2; ++j) {
                formatableBitSet.set(nArray[j]);
            }
        }
    }

    private void addGeneratedColumns(TableDescriptor tableDescriptor, ResultSetNode resultSetNode, ColumnDescriptorList columnDescriptorList, ColumnDescriptorList columnDescriptorList2) throws StandardException {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        ColumnDescriptorList columnDescriptorList3 = tableDescriptor.getGeneratedColumns();
        HashSet<String> hashSet = new HashSet<String>();
        UUID uUID = tableDescriptor.getObjectID();
        for (Object object : resultColumnList) {
            hashSet.add(((ResultColumn)object).getName());
        }
        block1: for (Object object : columnDescriptorList3) {
            DefaultInfo defaultInfo = ((ColumnDescriptor)object).getDefaultInfo();
            String[] stringArray = defaultInfo.getReferencedColumnNames();
            int n = stringArray.length;
            if (hashSet.contains(((ColumnDescriptor)object).getColumnName())) {
                columnDescriptorList.add(uUID, (ColumnDescriptor)object);
            }
            for (String string : stringArray) {
                if (!hashSet.contains(string)) continue;
                columnDescriptorList.add(uUID, (ColumnDescriptor)object);
                if (hashSet.contains(((ColumnDescriptor)object).getColumnName())) continue block1;
                columnDescriptorList2.add(uUID, (ColumnDescriptor)object);
                UntypedNullConstantNode untypedNullConstantNode = new UntypedNullConstantNode(this.getContextManager());
                ResultColumn resultColumn = new ResultColumn(((ColumnDescriptor)object).getType(), (ValueNode)untypedNullConstantNode, this.getContextManager());
                resultColumn.setColumnDescriptor(tableDescriptor, (ColumnDescriptor)object);
                resultColumn.setName(((ColumnDescriptor)object).getColumnName());
                resultColumnList.addResultColumn(resultColumn);
                continue block1;
            }
        }
    }

    private void normalizeCorrelatedColumns(ResultColumnList resultColumnList, FromTable fromTable) throws StandardException {
        String string = fromTable.getCorrelationName();
        if (string == null) {
            return;
        }
        TableName tableName = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        for (ResultColumn resultColumn : resultColumnList) {
            ColumnReference columnReference = resultColumn.getReference();
            if (columnReference == null || !string.equals(columnReference.getTableName())) continue;
            columnReference.setQualifiedTableName(tableName);
        }
    }

    private void checkTableNameAndScrubResultColumns(ResultColumnList resultColumnList) throws StandardException {
        for (ResultColumn resultColumn : resultColumnList) {
            boolean bl = false;
            if (resultColumn.getTableName() != null && !this.inMatchingClause()) {
                for (ResultSetNode resultSetNode : ((SelectNode)this.resultSet).fromList) {
                    FromTable fromTable = (FromTable)resultSetNode;
                    String string = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName().getTableName() : fromTable.getBaseTableName();
                    if (!resultColumn.getTableName().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw StandardException.newException("42X04", resultColumn.getTableName() + "." + resultColumn.getName());
                }
            }
            resultColumn.clearTableName();
        }
    }

    private void normalizeSynonymColumns(ResultColumnList resultColumnList, FromTable fromTable) throws StandardException {
        if (fromTable.getCorrelationName() != null) {
            return;
        }
        TableName tableName = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        super.normalizeSynonymColumns(resultColumnList, tableName);
    }

    private void forbidGenerationOverrides(ResultColumnList resultColumnList, ColumnDescriptorList columnDescriptorList) throws StandardException {
        int n = resultColumnList.size();
        ResultColumnList resultColumnList2 = this.resultSet.getResultColumns();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (resultColumn.wasDefaultColumn() || !resultColumn.hasGenerationClause() || (valueNode = ((ResultColumn)resultColumnList2.elementAt(i)).getExpression()) instanceof DefaultNode) continue;
            boolean bl = false;
            String string = resultColumn.getTableColumnDescriptor().getColumnName();
            int n2 = columnDescriptorList.size();
            for (int j = 0; j < n2; ++j) {
                String string2 = columnDescriptorList.elementAt(j).getColumnName();
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw StandardException.newException("42XA3", resultColumn.getName());
        }
    }
}

