/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class BackupForConfiguration
extends ConfigurationElement<BackupForConfiguration> {
    public static final AttributeDefinition<String> REMOTE_CACHE = AttributeDefinition.builder((Enum)Attribute.REMOTE_CACHE, null, String.class).immutable().build();
    public static final AttributeDefinition<String> REMOTE_SITE = AttributeDefinition.builder((Enum)Attribute.REMOTE_SITE, null, String.class).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> remoteCache;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> remoteSite;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupForConfiguration.class, new AttributeDefinition[]{REMOTE_CACHE, REMOTE_SITE});
    }

    public BackupForConfiguration(AttributeSet attributes) {
        super((Enum)Element.BACKUP_FOR, attributes, new ConfigurationElement[0]);
        this.remoteCache = attributes.attribute(REMOTE_CACHE);
        this.remoteSite = attributes.attribute(REMOTE_SITE);
    }

    public String remoteCache() {
        return (String)this.remoteCache.get();
    }

    public String remoteSite() {
        return (String)this.remoteSite.get();
    }

    public boolean isBackupFor(String remoteSite, String remoteCache) {
        boolean remoteSiteMatches = this.remoteSite() != null && this.remoteSite().equals(remoteSite);
        boolean remoteCacheMatches = this.remoteCache() != null && this.remoteCache().equals(remoteCache);
        return remoteSiteMatches && remoteCacheMatches;
    }
}

