/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.full.downing;

import akka.actor.Address;
import akka.actor.Props;
import akka.cluster.Member;
import com.xebialabs.xlplatform.cluster.NodeState$;
import com.xebialabs.xlplatform.cluster.full.downing.AutoDowning$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownReachable$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownUnreachable$;
import com.xebialabs.xlplatform.cluster.full.downing.MajorityLeaderAutoDowning$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005%<Qa\u0003\u0007\t\u0002e1Qa\u0007\u0007\t\u0002qAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u00192Aa\u0007\u0007\u0001w!I\u0001\u0007\u0002B\u0001B\u0003%\u0011g\u0010\u0005\nu\u0011\u0011\t\u0011)A\u0005c\u0001CQa\t\u0003\u0005\u0002\u0005CQ!\u0012\u0003\u0005\u0002\u0019CQ!\u0018\u0003\u0005ByCQa\u001a\u0003\u0005B!\f\u0011$T1k_JLG/\u001f'fC\u0012,'/Q;u_\u0012{wO\\5oO*\u0011QBD\u0001\bI><h.\u001b8h\u0015\ty\u0001#\u0001\u0003gk2d'BA\t\u0013\u0003\u001d\u0019G.^:uKJT!a\u0005\u000b\u0002\u0015ad\u0007\u000f\\1uM>\u0014XN\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001A\u0011!$A\u0007\u0002\u0019\tIR*\u00196pe&$\u0018\u0010T3bI\u0016\u0014\u0018)\u001e;p\t><h.\u001b8h'\t\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\tQ\u0001\u001d:paN$2aJ\u0018:!\tAS&D\u0001*\u0015\tQ3&A\u0003bGR|'OC\u0001-\u0003\u0011\t7n[1\n\u00059J#!\u0002)s_B\u001c\b\"\u0002\u0019\u0004\u0001\u0004\t\u0014aC:uC\ndW-\u00114uKJ\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u0011\u0011,(/\u0019;j_:T!AN\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00029g\tqa)\u001b8ji\u0016$UO]1uS>t\u0007\"\u0002\u001e\u0004\u0001\u0004\t\u0014!\u00053po:\u0014V-\\8wC2l\u0015M]4j]N\u0011A\u0001\u0010\t\u00035uJ!A\u0010\u0007\u0003-1+\u0017\rZ3s\u0003V$x\u000eR8x]&tw-Q2u_JL!\u0001M\u001f\n\u0005ijDc\u0001\"D\tB\u0011!\u0004\u0002\u0005\u0006a\u001d\u0001\r!\r\u0005\u0006u\u001d\u0001\r!M\u0001\u0007I\u0016\u001c\u0017\u000eZ3\u0015\u0003\u001d\u0003\"\u0001\u0013.\u000f\u0005%CfB\u0001&X\u001d\tYeK\u0004\u0002M+:\u0011Q\n\u0016\b\u0003\u001dNs!a\u0014*\u000e\u0003AS!!\u0015\r\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012BA\u000b\u0017\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003\u001b9I!!\u0017\u0007\u0002-1+\u0017\rZ3s\u0003V$x\u000eR8x]&tw-Q2u_JL!a\u0017/\u0003\u0015\u0011{wO\\!di&|gN\u0003\u0002Z\u0019\u0005!Am\\<o)\ty&\r\u0005\u0002\u001fA&\u0011\u0011m\b\u0002\u0005+:LG\u000fC\u0003d\u0013\u0001\u0007A-\u0001\u0003o_\u0012,\u0007C\u0001\u0015f\u0013\t1\u0017FA\u0004BI\u0012\u0014Xm]:\u0002\u0011\u0011|wO\\*fY\u001a$\u0012a\u0018")
public class MajorityLeaderAutoDowning
extends LeaderAutoDowningActor {
    public static Props props(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        return MajorityLeaderAutoDowning$.MODULE$.props(stableAfter, downRemovalMargin);
    }

    @Override
    public LeaderAutoDowningActor.DownAction decide() {
        int unreachableSize = this.unreachableMembers().size();
        int membersSize = this.members().size();
        this.log().info(new StringBuilder(60).append("Deciding on current cluster state: ").append(unreachableSize).append(" of ").append(membersSize).append(" members unreachable.").toString());
        if (unreachableSize * 2 == membersSize) {
            this.log().info("Both partitions are equal in size, break the tie by keeping the side with oldest member.");
            Address oldestMember = ((Member)this.members().head()).address();
            boolean oldestIsActive = this.isActiveMember(oldestMember);
            this.log().info(new StringBuilder(36).append("Oldest member [").append(oldestMember).append("] detected as being ").append((Object)(oldestIsActive ? "active" : "inactive")).append(".").toString());
            if (this.unreachable().apply((Object)oldestMember) && oldestIsActive) {
                this.log().info(new StringBuilder(60).append("Downing my partition [").append(this.reachable()).append("] - other partition has active oldest.").toString());
                return LeaderAutoDowningActor$DownReachable$.MODULE$;
            }
            if (this.reachable().apply((Object)oldestMember) && !oldestIsActive) {
                this.log().info(new StringBuilder(58).append("Downing my partition [").append(this.reachable()).append("] - my partition has invalid oldest.").toString());
                return LeaderAutoDowningActor$DownReachable$.MODULE$;
            }
            this.log().info(new StringBuilder(72).append("Downing other partition [").append(this.unreachable()).append("] - my partition has the current active oldest.").toString());
            return LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        }
        if (unreachableSize * 2 < membersSize) {
            this.log().info(new StringBuilder(47).append("We are in majority, downing other partition [").append(this.unreachable()).append("].").toString());
            return LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        }
        this.log().info(new StringBuilder(44).append("We are in minority, downing my partition [").append(this.reachable()).append("].").toString());
        return LeaderAutoDowningActor$DownReachable$.MODULE$;
    }

    @Override
    public void down(Address node) {
        this.log().info("Downing member [{}].", (Object)node);
        this.cluster().down(node);
    }

    @Override
    public void downSelf() {
        this.log().info("Deactivating myself.");
        NodeState$.MODULE$.setActive(false);
        AutoDowning$.MODULE$.setDowning(true);
        this.log().info("Downing myself.");
        this.shutdownMember();
    }

    public MajorityLeaderAutoDowning(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        super(stableAfter, downRemovalMargin);
    }
}

