/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.IDataSetConsumer;

public class BufferedConsumer
implements IDataSetConsumer {
    private IDataSetConsumer _wrappedConsumer;
    private TableBuffer _activeTable;
    private List _tableBuffers = new ArrayList();
    private Map _tableNames = new HashMap();

    public BufferedConsumer(IDataSetConsumer wrappedConsumer) {
        if (wrappedConsumer == null) {
            throw new NullPointerException("The parameter '_wrappedConsumer' must not be null");
        }
        this._wrappedConsumer = wrappedConsumer;
    }

    @Override
    public void startDataSet() throws DataSetException {
        this._wrappedConsumer.startDataSet();
    }

    @Override
    public void endDataSet() throws DataSetException {
        for (TableBuffer entry : this._tableBuffers) {
            ITableMetaData metaData = entry.getMetaData();
            this._wrappedConsumer.startTable(metaData);
            ArrayList dataRows = entry.getDataRows();
            for (Object[] rowValues : dataRows) {
                this._wrappedConsumer.row(rowValues);
            }
            dataRows.clear();
            this._wrappedConsumer.endTable();
        }
        this._wrappedConsumer.endDataSet();
    }

    @Override
    public void row(Object[] values) throws DataSetException {
        this._activeTable.getDataRows().add(values);
    }

    @Override
    public void startTable(ITableMetaData metaData) throws DataSetException {
        if (this._tableNames.containsKey(metaData.getTableName())) {
            this._activeTable = (TableBuffer)this._tableNames.get(metaData.getTableName());
            this._activeTable.setMetaData(metaData);
        } else {
            this._activeTable = new TableBuffer(metaData);
            this._tableBuffers.add(this._activeTable);
            this._tableNames.put(metaData.getTableName(), this._activeTable);
        }
    }

    @Override
    public void endTable() throws DataSetException {
        if (this._activeTable == null) {
            throw new IllegalStateException("The field _activeMetaData must not be null at this stage");
        }
        Column[] columns = this._activeTable.getMetaData().getColumns();
        int finalColumnCount = columns.length;
        int rowCount = this._activeTable.getDataRows().size();
        for (int i = 0; i < rowCount; ++i) {
            Object[] rowValues = (Object[])this._activeTable.getDataRows().get(i);
            if (rowValues.length >= finalColumnCount) continue;
            Object[] newRowValues = new Object[finalColumnCount];
            System.arraycopy(rowValues, 0, newRowValues, 0, rowValues.length);
            this._activeTable.getDataRows().set(i, newRowValues);
        }
    }

    private static class TableBuffer {
        private ITableMetaData metaData;
        private final ArrayList dataRows;

        public TableBuffer(ITableMetaData metaData) {
            this(metaData, new ArrayList());
        }

        public TableBuffer(ITableMetaData metaData, ArrayList dataRows) {
            this.metaData = metaData;
            this.dataRows = dataRows;
        }

        public ITableMetaData getMetaData() {
            return this.metaData;
        }

        public void setMetaData(ITableMetaData metaData) {
            this.metaData = metaData;
        }

        public ArrayList getDataRows() {
            return this.dataRows;
        }
    }
}

