/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.rbp;

import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.rbp.ResourceUri;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;

class PeerBlock {
    private static final String RESOURCE_URI = "Resource-Uri";
    private static final String SESSION_ID = "Session-Id";
    private static final String UPDATE_ID = "Update-Id";
    private static final String ACTION = "Action";
    private static final String ACTION_SUBSCRIBE = "Subscribe";
    private static final String ACTION_SUBSCRIBE_CONFIRM = "Subscribe-Confirm";
    private static final String ACTION_UPDATE = "Update";
    private static final String ACTION_UNSUBSCRIBE = "Unsubscribe";
    private static final String ACTION_UNPUBLISH = "Unpublish";
    private ResourceUri resourceUri = null;
    private int sessionId = -1;
    private String action = null;
    private int updateId = -1;
    private Bufferlo payload = null;

    private PeerBlock(ResourceUri resourceUri, int sessionId, String action, int updateId, Bufferlo payload) {
        this.resourceUri = resourceUri;
        this.sessionId = sessionId;
        this.action = action;
        this.updateId = updateId;
        this.payload = payload;
    }

    public static PeerBlock subscribeConfirm(ResourceUri resourceUri, int sessionId, int updateId, Bufferlo snapshot) {
        return new PeerBlock(resourceUri, sessionId, ACTION_SUBSCRIBE_CONFIRM, updateId, snapshot);
    }

    public static PeerBlock update(ResourceUri resourceUri, int sessionId, int updateId, Bufferlo delta) {
        return new PeerBlock(resourceUri, sessionId, ACTION_UPDATE, updateId, delta);
    }

    public static PeerBlock subscribe(ResourceUri resourceUri) {
        return new PeerBlock(resourceUri, -1, ACTION_SUBSCRIBE, -1, null);
    }

    public static PeerBlock unsubscribe(ResourceUri resourceUri) {
        return new PeerBlock(resourceUri, -1, ACTION_UNSUBSCRIBE, -1, null);
    }

    public static PeerBlock unpublish(ResourceUri resourceUri) {
        return new PeerBlock(resourceUri, -1, ACTION_UNPUBLISH, -1, null);
    }

    public boolean isSubscribeConfirm() {
        return ACTION_SUBSCRIBE_CONFIRM.equals(this.action);
    }

    public boolean isUpdate() {
        return ACTION_UPDATE.equals(this.action);
    }

    public boolean isSubscribe() {
        return ACTION_SUBSCRIBE.equals(this.action);
    }

    public boolean isUnsubscribe() {
        return ACTION_UNSUBSCRIBE.equals(this.action);
    }

    public boolean isUnpublish() {
        return ACTION_UNPUBLISH.equals(this.action);
    }

    public static PeerBlock fromBytes(Bufferlo bytes, String localHost, int localPort) throws ParseException {
        int blockEndIndex = bytes.indexOf("\\r\\n");
        if (blockEndIndex == -1) {
            return null;
        }
        String blockSizeInDecimal = bytes.readUntil("\\r\\n", false);
        int blockSizeWithHeaders = Integer.parseInt(blockSizeInDecimal);
        int bytesRequired = blockEndIndex + 2 + blockSizeWithHeaders + 2;
        if (bytes.length() < bytesRequired) {
            return null;
        }
        bytes.consume("[0-9]*\\r\\n");
        int lengthBeforeHeaders = bytes.length();
        TreeMap<String, String> headers = new TreeMap<String, String>();
        while (bytes.indexOf("\\r\\n") != 0) {
            String key = bytes.readUntil("\\:( )*");
            String value = bytes.readUntil("\\r\\n");
            headers.put(key, value);
        }
        bytes.consume("\\r\\n");
        int lengthAfterHeaders = bytes.length();
        int headersLength = lengthBeforeHeaders - lengthAfterHeaders;
        int payloadLength = blockSizeWithHeaders - headersLength;
        Bufferlo payload = bytes.consume(payloadLength);
        bytes.consume("\\r\\n");
        String resourceUriString = (String)headers.get(RESOURCE_URI);
        ResourceUri resourceUri = ResourceUri.localOrRemote(resourceUriString, localHost, localPort);
        String sessionIdString = (String)headers.get(SESSION_ID);
        String action = (String)headers.get(ACTION);
        String updateIdString = (String)headers.get(UPDATE_ID);
        int sessionId = sessionIdString != null ? Integer.parseInt(sessionIdString) : -1;
        int updateId = updateIdString != null ? Integer.parseInt(updateIdString) : -1;
        return new PeerBlock(resourceUri, sessionId, action, updateId, payload);
    }

    public Bufferlo toBytes(String localHost, int localPort) {
        Bufferlo writer = new Bufferlo();
        TreeMap<String, Object> headers = new TreeMap<String, Object>();
        if (this.resourceUri != null) {
            headers.put(RESOURCE_URI, this.resourceUri.toString(localHost, localPort));
        }
        if (this.sessionId != -1) {
            headers.put(SESSION_ID, new Integer(this.sessionId));
        }
        if (this.action != null) {
            headers.put(ACTION, this.action);
        }
        if (this.updateId != -1) {
            headers.put(UPDATE_ID, new Integer(this.updateId));
        }
        for (Map.Entry mapEntry : headers.entrySet()) {
            writer.write(mapEntry.getKey().toString());
            writer.write(": ");
            writer.write(mapEntry.getValue().toString());
            writer.write("\r\n");
        }
        writer.write("\r\n");
        if (this.payload != null) {
            writer.append(this.payload.duplicate());
        }
        Bufferlo writerWithSize = new Bufferlo();
        writerWithSize.write("" + writer.length());
        writerWithSize.write("\r\n");
        writerWithSize.append(writer);
        writerWithSize.write("\r\n");
        return writerWithSize;
    }

    public String getAction() {
        return this.action;
    }

    public Bufferlo getPayload() {
        return this.payload;
    }

    public int getUpdateId() {
        return this.updateId;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public ResourceUri getResourceUri() {
        return this.resourceUri;
    }
}

