/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.springframework.aop.Advisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.Jsr250AuthorizationManager;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class Jsr250MethodSecurityConfiguration {
    private final Jsr250AuthorizationManager jsr250AuthorizationManager = new Jsr250AuthorizationManager();

    Jsr250MethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    Advisor jsr250AuthorizationMethodInterceptor() {
        return AuthorizationManagerBeforeMethodInterceptor.jsr250((Jsr250AuthorizationManager)this.jsr250AuthorizationManager);
    }

    @Autowired(required=false)
    void setGrantedAuthorityDefaults(GrantedAuthorityDefaults grantedAuthorityDefaults) {
        this.jsr250AuthorizationManager.setRolePrefix(grantedAuthorityDefaults.getRolePrefix());
    }
}

