/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.BrokerBalancerControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.balancing.BrokerBalancer;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetResult;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.JsonLoader;

public class BrokerBalancerControlImpl
extends AbstractControl
implements BrokerBalancerControl {
    private final BrokerBalancer balancer;
    private static CompositeType parameterType;
    private static TabularType parametersType;
    private static CompositeType transportConfigurationType;
    private static CompositeType targetType;

    public BrokerBalancerControlImpl(BrokerBalancer balancer, StorageManager storageManager) throws NotCompliantMBeanException {
        super(BrokerBalancerControl.class, storageManager);
        this.balancer = balancer;
    }

    public CompositeData getTarget(String key) throws Exception {
        TargetResult result = this.balancer.getTarget(key);
        if (TargetResult.Status.OK == result.getStatus()) {
            CompositeDataSupport connectorData = null;
            TransportConfiguration connector = result.getTarget().getConnector();
            if (connector != null) {
                TabularDataSupport paramsData = new TabularDataSupport(this.getParametersType());
                for (Map.Entry param : connector.getParams().entrySet()) {
                    paramsData.put(new CompositeDataSupport(this.getParameterType(), new String[]{"key", "value"}, new Object[]{param.getKey(), param.getValue() == null ? null : param.getValue().toString()}));
                }
                connectorData = new CompositeDataSupport(this.getTransportConfigurationType(), new String[]{"name", "factoryClassName", "params"}, new Object[]{connector.getName(), connector.getFactoryClassName(), paramsData});
            }
            return new CompositeDataSupport(this.getTargetCompositeType(), new String[]{"nodeID", "local", "connector"}, new Object[]{result.getTarget().getNodeID(), result.getTarget().isLocal(), connectorData});
        }
        return null;
    }

    public String getTargetAsJSON(String key) {
        TargetResult result = this.balancer.getTarget(key);
        if (TargetResult.Status.OK == result.getStatus()) {
            TransportConfiguration connector = result.getTarget().getConnector();
            JsonObjectBuilder targetDataBuilder = JsonLoader.createObjectBuilder().add("nodeID", result.getTarget().getNodeID()).add("local", result.getTarget().isLocal());
            if (connector == null) {
                targetDataBuilder.addNull("connector");
            } else {
                targetDataBuilder.add("connector", (JsonValue)connector.toJson());
            }
            return targetDataBuilder.build().toString();
        }
        return null;
    }

    public void setLocalTargetFilter(String regExp) {
        this.balancer.setLocalTargetFilter(regExp);
    }

    public String getLocalTargetFilter() {
        return this.balancer.getLocalTargetFilter();
    }

    public void setTargetKeyFilter(String regExp) {
        this.balancer.getTargetKeyResolver().setKeyFilter(regExp);
    }

    public String getTargetKeyFilter() {
        return this.balancer.getTargetKeyResolver().getKeyFilter();
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(BrokerBalancerControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(BrokerBalancerControl.class);
    }

    private CompositeType getParameterType() throws OpenDataException {
        if (parameterType == null) {
            parameterType = new CompositeType("java.util.Map.Entry<java.lang.String, java.lang.String>", "Parameter", new String[]{"key", "value"}, new String[]{"Parameter key", "Parameter value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        }
        return parameterType;
    }

    private TabularType getParametersType() throws OpenDataException {
        if (parametersType == null) {
            parametersType = new TabularType("java.util.Map<java.lang.String, java.lang.String>", "Parameters", this.getParameterType(), new String[]{"key"});
        }
        return parametersType;
    }

    private CompositeType getTransportConfigurationType() throws OpenDataException {
        if (transportConfigurationType == null) {
            transportConfigurationType = new CompositeType(TransportConfiguration.class.getName(), "TransportConfiguration", new String[]{"name", "factoryClassName", "params"}, new String[]{"TransportConfiguration name", "TransportConfiguration factoryClassName", "TransportConfiguration params"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, this.getParametersType()});
        }
        return transportConfigurationType;
    }

    private CompositeType getTargetCompositeType() throws OpenDataException {
        if (targetType == null) {
            targetType = new CompositeType(Target.class.getName(), "Target", new String[]{"nodeID", "local", "connector"}, new String[]{"Target nodeID", "Target local", "Target connector"}, new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, this.getTransportConfigurationType()});
        }
        return targetType;
    }
}

