/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core;

import com.xebialabs.deployit.core.StringValue;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapStringStringView
implements Map<String, String>,
Serializable {
    public static final Function<String, StringValue> STRING_STRING_VALUE_FUNCTION = input -> (StringValue)MapStringStringView.stringToStringValue(input);
    private Map<String, StringValue> wrapped = new HashMap<String, StringValue>();

    public MapStringStringView() {
    }

    public MapStringStringView(Map<String, StringValue> wrapped) {
        this.wrapped = wrapped instanceof Serializable ? wrapped : new HashMap<String, StringValue>(wrapped);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(MapStringStringView.stringToStringValue(value));
    }

    @Override
    public String get(Object key) {
        StringValue wrappedValue = this.getWrappedValue(key);
        return wrappedValue != null ? wrappedValue.toString() : null;
    }

    public StringValue getWrappedValue(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public String put(String key, String value) {
        StringValue put = this.wrapped.put(key, (StringValue)MapStringStringView.stringToStringValue(value));
        return put != null ? put.toString() : null;
    }

    @Override
    public StringValue put(String key, StringValue value) {
        return this.wrapped.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.wrapped.remove(key).toString();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        if (m instanceof MapStringStringView) {
            this.wrapped.putAll(((MapStringStringView)m).getWrapped());
        } else {
            Set<Map.Entry<? extends String, ? extends String>> entries = m.entrySet();
            Stream stream = entries.stream();
            Collector<Map.Entry, ?, Map<String, StringValue>> tMapCollector = Collectors.toMap(Map.Entry::getKey, e -> STRING_STRING_VALUE_FUNCTION.apply((String)e.getValue()));
            this.wrapped.putAll(stream.collect(tMapCollector));
        }
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.wrapped.values().stream().map(StringValue::toString).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.wrapped.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ((StringValue)e.getValue()).toString())).collect(Collectors.toSet());
    }

    public Map<String, StringValue> getWrapped() {
        return this.wrapped;
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof MapStringStringView) {
            return this.wrapped.equals(((MapStringStringView)obj).getWrapped());
        }
        if (obj instanceof Map) {
            return this.wrapped.equals(obj);
        }
        return false;
    }

    public String toString() {
        return "MapStringStringView[" + this.wrapped.toString() + "]";
    }

    protected static Object stringToStringValue(Object o) {
        if (o instanceof String) {
            return new StringValue((String)o);
        }
        return o;
    }

    public static MapStringStringView from(Map<String, String> mapStringString) {
        if (mapStringString instanceof MapStringStringView) {
            return (MapStringStringView)mapStringString;
        }
        MapStringStringView stringView = new MapStringStringView();
        if (mapStringString != null) {
            stringView.putAll((Map<? extends String, ? extends String>)mapStringString);
        }
        return stringView;
    }

    public static MapStringStringView copy(Map<String, String> map) {
        if (map instanceof MapStringStringView) {
            return new MapStringStringView(new HashMap<String, StringValue>(((MapStringStringView)map).getWrapped()));
        }
        return MapStringStringView.from(map);
    }

    public MapStringStringView encrypt() {
        HashMap<String, StringValue> newMap = new HashMap<String, StringValue>();
        for (String s : this.wrapped.keySet()) {
            newMap.put(s, this.wrapped.get(s).encrypt());
        }
        return new MapStringStringView(newMap);
    }
}

