/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.nimbusds.jose.jwk.JWK;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B*U\u0001\u0005D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\ta\u0002\u0011\t\u0011)A\u0005c\")q\u000f\u0001C\u0001q\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u000b\u0001\u0001\u0006Ia \u0005\t\u0003/\u0001!\u0019!C\u0001}\"9\u0011\u0011\u0004\u0001!\u0002\u0013y\b\u0002CA\u000e\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005u\u0001\u0001)A\u0005\u007f\"A\u0011q\u0004\u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\"\u0001\u0001\u000b\u0011B@\t\u0011\u0005\r\u0002A1A\u0005\u0002yDq!!\n\u0001A\u0003%q\u0010\u0003\u0005\u0002(\u0001\u0011\r\u0011\"\u0001\u007f\u0011\u001d\tI\u0003\u0001Q\u0001\n}D\u0001\"a\u000b\u0001\u0001\u0004%\tA \u0005\n\u0003[\u0001\u0001\u0019!C\u0001\u0003_Aq!a\u000f\u0001A\u0003&q\u0010\u0003\u0005\u0002>\u0001\u0001\r\u0011\"\u0001\u007f\u0011%\ty\u0004\u0001a\u0001\n\u0003\t\t\u0005C\u0004\u0002F\u0001\u0001\u000b\u0015B@\t\u0011\u0005\u001d\u0003\u00011A\u0005\u0002yD\u0011\"!\u0013\u0001\u0001\u0004%\t!a\u0013\t\u000f\u0005=\u0003\u0001)Q\u0005\u007f\"A\u0011\u0011\u000b\u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002T\u0001\u0001\u000b\u0011B@\t\u0011\u0005U\u0003A1A\u0005\u0002yDq!a\u0016\u0001A\u0003%q\u0010\u0003\u0005\u0002Z\u0001\u0011\r\u0011\"\u0001\u007f\u0011\u001d\tY\u0006\u0001Q\u0001\n}D\u0001\"!\u0018\u0001\u0005\u0004%\tA \u0005\b\u0003?\u0002\u0001\u0015!\u0003\u0000\u0011!\t\t\u0007\u0001b\u0001\n\u0003q\bbBA2\u0001\u0001\u0006Ia \u0005\t\u0003K\u0002!\u0019!C\u0001}\"9\u0011q\r\u0001!\u0002\u0013y\b\u0002CA5\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005-\u0004\u0001)A\u0005\u007f\"A\u0011Q\u000e\u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002p\u0001\u0001\u000b\u0011B@\t\u0011\u0005E\u0004A1A\u0005\u0002yDq!a\u001d\u0001A\u0003%q\u0010\u0003\u0005\u0002v\u0001\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t9\b\u0001Q\u0001\n}D\u0001\"!\u001f\u0001\u0005\u0004%\tA \u0005\b\u0003w\u0002\u0001\u0015!\u0003\u0000\u0011!\ti\b\u0001b\u0001\n\u0003q\bbBA@\u0001\u0001\u0006Ia \u0005\t\u0003\u0003\u0003!\u0019!C\u0001}\"9\u00111\u0011\u0001!\u0002\u0013y\b\u0002CAC\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005\u001d\u0005\u0001)A\u0005\u007f\"A\u0011\u0011\u0012\u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\f\u0002\u0001\u000b\u0011B@\t\u0011\u00055\u0005A1A\u0005\u0002yDq!a$\u0001A\u0003%q\u0010\u0003\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t\u0019\n\u0001Q\u0001\n}D\u0001\"!&\u0001\u0005\u0004%\tA \u0005\b\u0003/\u0003\u0001\u0015!\u0003\u0000\u0011!\tI\n\u0001b\u0001\n\u0003q\bbBAN\u0001\u0001\u0006Ia \u0005\t\u0003;\u0003!\u0019!C\u0001}\"9\u0011q\u0014\u0001!\u0002\u0013y\b\u0002CAQ\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005\r\u0006\u0001)A\u0005\u007f\"A\u0011Q\u0015\u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002(\u0002\u0001\u000b\u0011B@\t\u0013\u0005%\u0006\u00011A\u0005\u0002\u0005-\u0006\"CA_\u0001\u0001\u0007I\u0011AA`\u0011!\t\u0019\r\u0001Q!\n\u00055\u0006bCAc\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000fD1\"a7\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002^\"Y\u0011\u0011\u001d\u0001A\u0002\u0003\u0005\u000b\u0015BAe\u0011%\t\u0019\u000f\u0001a\u0001\n\u0003\t)\u000fC\u0005\u0002t\u0002\u0001\r\u0011\"\u0001\u0002v\"A\u0011\u0011 \u0001!B\u0013\t9\u000fC\u0004\u0002|\u0002!I!!@\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!1\u0003\u0001\u0005\n\tU\u0001b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0005)y\u0015\u000eZ2D_:4\u0017n\u001a\u0006\u0003+Z\u000bAaY8oM*\u0011q\u000bW\u0001\u0005_&$7M\u0003\u0002Z5\u0006q\u0011-\u001e;iK:$\u0018nY1uS>t'BA.]\u0003!AH\u000eZ3qY>L(BA/_\u0003%AXMY5bY\u0006\u00147OC\u0001`\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\r\u0005\u0002dM6\tAMC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9GM\u0001\u0004B]f\u0014VMZ\u0001\u0007G>tg-[4\u0011\u0005)tW\"A6\u000b\u0005!d'BA7_\u0003!!\u0018\u0010]3tC\u001a,\u0017BA8l\u0005\u0019\u0019uN\u001c4jO\u0006\u00192/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011!/^\u0007\u0002g*\u0011A\u000fX\u0001\tI\u0016\u0004Hn\\=ji&\u0011ao\u001d\u0002\u0014'\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007e\\H\u0010\u0005\u0002{\u00015\tA\u000bC\u0003i\u0007\u0001\u0007\u0011\u000eC\u0003q\u0007\u0001\u0007\u0011/\u0001\bsK\u001eL7\u000f\u001e:bi&|g.\u00133\u0016\u0003}\u0004B!!\u0001\u0002\u00109!\u00111AA\u0006!\r\t)\u0001Z\u0007\u0003\u0003\u000fQ1!!\u0003a\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00023\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t\"a\u0005\u0003\rM#(/\u001b8h\u0015\r\ti\u0001Z\u0001\u0010e\u0016<\u0017n\u001d;sCRLwN\\%eA\u0005A1\r\\5f]RLE-A\u0005dY&,g\u000e^%eA\u0005a1\r\\5f]R\u001cVm\u0019:fi\u0006i1\r\\5f]R\u001cVm\u0019:fi\u0002\n\u0001c\u00197jK:$\u0018)\u001e;i\u001b\u0016$\bn\u001c3\u0002#\rd\u0017.\u001a8u\u0003V$\b.T3uQ>$\u0007%\u0001\tdY&,g\u000e^!vi\"TukU!mO\u0006\t2\r\\5f]R\fU\u000f\u001e5K/N\u000bEn\u001a\u0011\u0002\u0015Q|7.\u001a8LKfLE-A\u0006u_.,gnS3z\u0013\u0012\u0004\u0013\u0001D6fsN#xN]3QCRD\u0017\u0001E6fsN#xN]3QCRDw\fJ3r)\u0011\t\t$a\u000e\u0011\u0007\r\f\u0019$C\u0002\u00026\u0011\u0014A!\u00168ji\"A\u0011\u0011H\t\u0002\u0002\u0003\u0007q0A\u0002yIE\nQb[3z'R|'/\u001a)bi\"\u0004\u0013\u0001E6fsN#xN]3QCN\u001cxo\u001c:e\u0003QYW-_*u_J,\u0007+Y:to>\u0014Hm\u0018\u0013fcR!\u0011\u0011GA\"\u0011!\tI\u0004FA\u0001\u0002\u0004y\u0018!E6fsN#xN]3QCN\u001cxo\u001c:eA\u0005a1.Z=Ti>\u0014X\rV=qK\u0006\u00012.Z=Ti>\u0014X\rV=qK~#S-\u001d\u000b\u0005\u0003c\ti\u0005\u0003\u0005\u0002:]\t\t\u00111\u0001\u0000\u00035YW-_*u_J,G+\u001f9fA\u0005A1.Z=BY&\f7/A\u0005lKf\fE.[1tA\u0005Y1.Z=QCN\u001cxo\u001c:e\u00031YW-\u001f)bgN<xN\u001d3!\u0003M!WMZ1vYR\\U-_*u_J,\u0007+\u0019;i\u0003Q!WMZ1vYR\\U-_*u_J,\u0007+\u0019;iA\u00059B-\u001a4bk2$8*Z=Ti>\u0014X\rU1tg^|'\u000fZ\u0001\u0019I\u00164\u0017-\u001e7u\u0017\u0016L8\u000b^8sKB\u000b7o]<pe\u0012\u0004\u0013AB5tgV,'/A\u0004jgN,XM\u001d\u0011\u0002\u0011)<8n]0ve&\f\u0011B[<lg~+(/\u001b\u0011\u0002\u001d\u0005\u001c7-Z:t)>\\WM\\+sS\u0006y\u0011mY2fgN$vn[3o+JL\u0007%\u0001\u000bvg\u0016\u0014\u0018)\u001e;i_JL'0\u0019;j_:,&/[\u0001\u0016kN,'/Q;uQ>\u0014\u0018N_1uS>tWK]5!\u0003%awnZ8viV\u0013\u0018.\u0001\u0006m_\u001e|W\u000f^+sS\u0002\n1B]3eSJ,7\r^+sS\u0006a!/\u001a3je\u0016\u001cG/\u0016:jA\u0005)\u0002o\\:u\u0019><w.\u001e;SK\u0012L'/Z2u+JL\u0017A\u00069pgRdunZ8viJ+G-\u001b:fGR,&/\u001b\u0011\u0002\u001dI|G.Z:DY\u0006LWNT1nK\u0006y!o\u001c7fg\u000ec\u0017-[7OC6,\u0007%A\tvg\u0016\u0014h*Y7f\u00072\f\u0017.\u001c(b[\u0016\f!#^:fe:\u000bW.Z\"mC&lg*Y7fA\u0005i\u0011\u000e\u001a+pW\u0016t'jV*BY\u001e\fa\"\u001b3U_.,gNS,T\u00032<\u0007%A\tbG\u000e,7o\u001d+pW\u0016t\u0017j]:vKJ\f!#Y2dKN\u001cHk\\6f]&\u001b8/^3sA\u0005\u0019\u0012mY2fgN$vn[3o\u0003V$\u0017.\u001a8dK\u0006!\u0012mY2fgN$vn[3o\u0003V$\u0017.\u001a8dK\u0002\n\u0011#Y2dKN\u001cHk\\6f].+\u00170\u0016:j\u0003I\t7mY3tgR{7.\u001a8LKf,&/\u001b\u0011\u0002#\u0005\u001c7-Z:t)>\\WM\u001c&X'\u0006cw-\u0001\nbG\u000e,7o\u001d+pW\u0016t'jV*BY\u001e\u0004\u0013\u0001F1dG\u0016\u001c8\u000fV8lK:\u001cVm\u0019:fi.+\u00170A\u000bbG\u000e,7o\u001d+pW\u0016t7+Z2sKR\\U-\u001f\u0011\u0002\u001d\u0015DH/\u001a:oC2|Fn\\4j]\u0006yQ\r\u001f;fe:\fGn\u00187pO&t\u0007%\u0001\fm_\u001eLg.T3uQ>$G)Z:de&\u0004H/[8o\u0003]awnZ5o\u001b\u0016$\bn\u001c3EKN\u001c'/\u001b9uS>t\u0007%A\u0005qe>D\u0018\u0010S8ti\u0006Q\u0001O]8ys\"{7\u000f\u001e\u0011\u0002\u0013A\u0014x\u000e_=Q_J$XCAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000bA\u0001\\1oO*\u0011\u0011qW\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002<\u0006E&aB%oi\u0016<WM]\u0001\u000eaJ|\u00070\u001f)peR|F%Z9\u0015\t\u0005E\u0012\u0011\u0019\u0005\n\u0003s1\u0015\u0011!a\u0001\u0003[\u000b!\u0002\u001d:pqf\u0004vN\u001d;!\u0003\rQwo[\u000b\u0003\u0003\u0013\u0004B!a3\u0002X6\u0011\u0011Q\u001a\u0006\u0005\u0003\u000b\fyM\u0003\u0003\u0002R\u0006M\u0017\u0001\u00026pg\u0016T1!!6_\u0003!q\u0017.\u001c2vg\u0012\u001c\u0018\u0002BAm\u0003\u001b\u00141AS,L\u0003\u001dQwo[0%KF$B!!\r\u0002`\"I\u0011\u0011H%\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0005U^\\\u0007%\u0001\u0004tG>\u0004Xm]\u000b\u0003\u0003O\u0004R!!;\u0002p~l!!a;\u000b\t\u00055\u0018QW\u0001\u0005kRLG.\u0003\u0003\u0002r\u0006-(\u0001\u0002'jgR\f!b]2pa\u0016\u001cx\fJ3r)\u0011\t\t$a>\t\u0013\u0005eB*!AA\u0002\u0005\u001d\u0018aB:d_B,7\u000fI\u0001\u0012O\u0016$8\u000b\u001e:j]\u001e\u0004&o\u001c9feRLHcB@\u0002\u0000\n\u0005!Q\u0001\u0005\u0006Q:\u0003\r!\u001b\u0005\u0007\u0005\u0007q\u0005\u0019A@\u0002\t9\fW.\u001a\u0005\u0007\u0005\u000fq\u0005\u0019A@\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\u0002\u001d\u001d,G/\u00138u!J|\u0007/\u001a:usRA\u0011Q\u0016B\u0007\u0005\u001f\u0011\t\u0002C\u0003i\u001f\u0002\u0007\u0011\u000e\u0003\u0004\u0003\u0004=\u0003\ra \u0005\b\u0005\u000fy\u0005\u0019AAW\u0003M9W\r^#oG>$W\rZ+sSN#(/\u001b8h)\ry(q\u0003\u0005\u0007\u00053\u0001\u0006\u0019A@\u0002\u0007U\u0014\u0018.A\nhKR$UmY8eK\u0012,&/[*ue&tw\r\u0006\u0003\u0003 \t\r\u0002\u0003BAX\u0005CIA!!\u0005\u00022\"1!\u0011D)A\u0002}\fQcZ3u'R\u0014\u0018N\\4MSN$\bK]8qKJ$\u0018\u0010\u0006\u0005\u0002h\n%\"1\u0006B\u0017\u0011\u0015A'\u000b1\u0001j\u0011\u0019\u0011\u0019A\u0015a\u0001\u007f\"9!q\u0001*A\u0002\u0005\u001d\b")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String clientAuthJWSAlg;
    private final String tokenKeyId;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private final String keyAlias;
    private final String keyPassword;
    private final String defaultKeyStorePath;
    private final String defaultKeyStorePassword;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private JWK jwk;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String clientAuthJWSAlg() {
        return this.clientAuthJWSAlg;
    }

    public String tokenKeyId() {
        return this.tokenKeyId;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public void keyStorePath_$eq(String x$1) {
        this.keyStorePath = x$1;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public void keyStorePassword_$eq(String x$1) {
        this.keyStorePassword = x$1;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public void keyStoreType_$eq(String x$1) {
        this.keyStoreType = x$1;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public String defaultKeyStorePath() {
        return this.defaultKeyStorePath;
    }

    public String defaultKeyStorePassword() {
        return this.defaultKeyStorePassword;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public JWK jwk() {
        return this.jwk;
    }

    public void jwk_$eq(JWK x$1) {
        this.jwk = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.clientAuthJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg", MacAlgorithm.HS256.getName());
        this.tokenKeyId = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.tokenKeyId", "");
        this.keyStorePath = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path", "");
        this.keyStorePassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.password", "");
        this.keyStoreType = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.type", "");
        this.keyAlias = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.alias", "");
        this.keyPassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.password", "");
        this.defaultKeyStorePath = serverConfiguration.getKeyStorePath();
        this.defaultKeyStorePassword = serverConfiguration.getKeyStorePassword();
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", new StringBuilder(20).append(serverConfiguration.getServerUrl()).append("login/external-login").toString()));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = new StringBuilder(22).append("/oauth2/authorization").append("/").append(this.registrationId()).toString();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "deploy.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

