/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.InputMismatchException;
import kamon.context.generated.binary.context.Entry;
import kamon.context.generated.binary.context.Tags;

public class Context
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public static int colferListMax = 65536;
    public Tags tags;
    public Entry[] entries;
    private static final Entry[] _zeroEntries = new Entry[0];
    private static final long serialVersionUID = 2L;

    public Context() {
        this.init();
    }

    private void init() {
        this.entries = _zeroEntries;
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            if (this.tags != null) {
                byArray[n2++] = 0;
                n2 = this.tags.marshal(byArray, n2);
            }
            if (this.entries.length != 0) {
                byArray[n2++] = 1;
                Entry[] entryArray = this.entries;
                int n3 = entryArray.length;
                if (n3 > colferListMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Context.entries length %d exceeds %d elements", n3, colferListMax));
                }
                while (n3 > 127) {
                    byArray[n2++] = (byte)(n3 | 0x80);
                    n3 >>>= 7;
                }
                byArray[n2++] = (byte)n3;
                for (int i = 0; i < entryArray.length; ++i) {
                    Entry entry = entryArray[i];
                    if (entry == null) {
                        entryArray[i] = entry = new Entry();
                    }
                    n2 = entry.marshal(byArray, n2);
                }
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.Context exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block14: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                byte by = byArray[n3++];
                if (by == 0) {
                    this.tags = new Tags();
                    n3 = this.tags.unmarshal(byArray, n3, n2);
                    by = byArray[n3++];
                }
                if (by == 1) {
                    int n4;
                    int n5 = 0;
                    int n6 = 0;
                    while (true) {
                        n4 = byArray[n3++];
                        n5 |= (n4 & 0x7F) << n6;
                        if (n6 == 28 || n4 >= 0) break;
                        n6 += 7;
                    }
                    if (n5 < 0 || n5 > colferListMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Context.entries length %d exceeds %d elements", n5, colferListMax));
                    }
                    Entry[] entryArray = new Entry[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        Entry entry = new Entry();
                        n3 = entry.unmarshal(byArray, n3, n2);
                        entryArray[n4] = entry;
                    }
                    this.entries = entryArray;
                    by = byArray[n3++];
                }
                if (by != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block14;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Context exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.Context exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public Tags getTags() {
        return this.tags;
    }

    public void setTags(Tags tags) {
        this.tags = tags;
    }

    public Context withTags(Tags tags) {
        this.tags = tags;
        return this;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public void setEntries(Entry[] entryArray) {
        this.entries = entryArray;
    }

    public Context withEntries(Entry[] entryArray) {
        this.entries = entryArray;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        if (this.tags != null) {
            n = 31 * n + this.tags.hashCode();
        }
        for (Entry entry : this.entries) {
            n = 31 * n + (entry == null ? 0 : entry.hashCode());
        }
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof Context && this.equals((Context)object);
    }

    public final boolean equals(Context context) {
        if (context == null) {
            return false;
        }
        if (context == this) {
            return true;
        }
        return context.getClass() == Context.class && (this.tags == null ? context.tags == null : this.tags.equals(context.tags)) && Arrays.equals(this.entries, context.entries);
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public Context next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        Context context = new Context();
                        this.offset = context.unmarshal(this.buf, this.offset, this.i);
                        return context;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

