/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.util.Util;

public class PubSub {
    final Map<String, JChannel> topics = new HashMap<String, JChannel>();

    void start(String props) throws Exception {
        System.out.println("\n========== PubSub instance started =========");
        System.out.println("Valid commands are:");
        System.out.println("subscribe <topic>");
        System.out.println("unsubscribe <topic>");
        System.out.println("exit");
        System.out.println("print (prints all topics)");
        System.out.println("<topic>: <message>\n\n");
        System.out.println("Example");
        System.out.println("subscribe one\nsubscribe two\none: hello world\n\n");
        block0: while (true) {
            JChannel ch;
            System.out.print("> ");
            String line = Util.readLine(System.in).trim();
            if (line.startsWith("subscribe")) {
                final String topic = line.substring("subscribe".length()).trim();
                if (this.topics.containsKey(topic)) continue;
                ch = PubSub.createSharedChannel("pubsub", props);
                ch.setReceiver(new ReceiverAdapter(){

                    @Override
                    public void receive(Message msg) {
                        System.out.println("[" + topic + "] << " + msg.getObject());
                    }
                });
                ch.connect(topic);
                this.topics.put(topic, ch);
                System.out.println("subscribed to topic \"" + topic + "\"; current subscriptions: " + this.topics.keySet());
                continue;
            }
            if (line.startsWith("unsubscribe")) {
                String topic = line.substring("unsubscribe".length()).trim();
                ch = this.topics.remove(topic);
                if (ch == null) {
                    System.err.println("Topic \"" + topic + "\" not found");
                    continue;
                }
                Util.close((Closeable)ch);
                System.out.println("unsubscribed from topic \"" + topic + "\"; current subscriptions: " + this.topics.keySet());
                continue;
            }
            if (line.startsWith("exit")) break;
            if (line.startsWith("print")) {
                System.out.println("topics: " + this.topics.keySet());
                continue;
            }
            int index = line.indexOf(":");
            if (index == -1) {
                Iterator<JChannel> i$ = this.topics.values().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    JChannel ch2 = i$.next();
                    Message msg = new Message(null, null, line);
                    ch2.send(msg);
                }
            }
            String topic = line.substring(0, index).trim();
            String message = line.substring(index).trim();
            JChannel ch3 = this.topics.get(topic);
            if (ch3 == null) {
                System.err.println("sending to topic \"" + topic + "\" failed as topic doesn't exist, subscribe first");
                continue;
            }
            Message msg = new Message(null, null, message);
            ch3.send(msg);
        }
        for (JChannel ch : this.topics.values()) {
            Util.close((Closeable)ch);
        }
    }

    private static JChannel createSharedChannel(String singleton_name, String props) throws Exception {
        ProtocolStackConfigurator config = ConfiguratorFactory.getStackConfigurator(props);
        List<ProtocolConfiguration> protocols = config.getProtocolStack();
        ProtocolConfiguration transport = protocols.get(0);
        transport.getProperties().put("singleton_name", singleton_name);
        return new JChannel(config);
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-props")) {
                PubSub.help();
                return;
            }
            props = args[++i];
        }
        new PubSub().start(props);
    }

    protected static void help() {
        System.out.println("PubSub [-props props]");
        System.out.println("Valid commands are:");
        System.out.println("subscribe <topic>");
        System.out.println("unsubscribe <topic>");
        System.out.println("exit");
        System.out.println("print (prints all topics)");
        System.out.println("<topic>: <message>\n\n");
        System.out.println("Example");
        System.out.println("subscribe one\nsubscribe two\none: hello world");
    }
}

