@echo off
REM
REM Batch script to start the XL Deploy CLI
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get Java executable
if "%JAVA_HOME%"=="" (
  set JAVACMD=java
) else (
  set JAVACMD="%JAVA_HOME%\bin\java"
)

REM Get JVM options
if "%DEPLOYIT_CLI_OPTS%"=="" (
  set DEPLOYIT_CLI_OPTS=-Xmx512m
)

REM Get XL Deploy cli home dir
if "%DEPLOYIT_CLI_HOME%"=="" (
  cd /d "%~dp0"
  cd ..
  set DEPLOYIT_CLI_HOME=!CD!
)

cd /d "%DEPLOYIT_CLI_HOME%"

REM Build XL Deploy cli classpath
set DEPLOYIT_CLI_CLASSPATH=conf
for %%i in (hotfix\*.jar) do set DEPLOYIT_CLI_CLASSPATH=!DEPLOYIT_CLI_CLASSPATH!;%%i
for %%i in (lib\*.jar) do set DEPLOYIT_CLI_CLASSPATH=!DEPLOYIT_CLI_CLASSPATH!;%%i
for %%i in (plugins\*.jar) do set DEPLOYIT_CLI_CLASSPATH=!DEPLOYIT_CLI_CLASSPATH!;%%i

REM Run XL Deploy cli
setlocal DISABLEDELAYEDEXPANSION
%JAVACMD% %DEPLOYIT_CLI_OPTS% -classpath "%DEPLOYIT_CLI_CLASSPATH%" com.xebialabs.deployit.cli.Cli %*
set RES=%ERRORLEVEL%
if not %RES% == 0 (
  exit /B %RES%
)

:end
endlocal

