/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext;

import com.datical.liquibase.ext.SqlPlusFileCreator;
import com.datical.liquibase.ext.SqlPlusFileCreator$FileTypeEnum;
import com.datical.liquibase.ext.appdba.sqlplus.change.exception.DaticalSpErrorLogException;
import com.datical.liquibase.ext.config.SqlplusConfiguration;
import com.datical.liquibase.ext.config.SqlplusConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.logging.Logger;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlPlusRunner
extends ExecuteShellCommandChange {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private File spoolFile = null;
    private Boolean keepTempFile;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private Boolean tempOverwrite;
    private static final String DATICAL_SPERRORLOG = "DATICAL_SPERRORLOG";
    private String errorLoggingIdentifier;

    public SqlPlusRunner() {
    }

    public SqlPlusRunner(ChangeSet changeSet, Sql[] sqlArray, ResourceAccessor resourceAccessor) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
        this.errorLoggingIdentifier = UUID.randomUUID().toString();
    }

    @Override
    protected List<String> createFinalCommandArray(Database object) {
        this.loadSqlplusProperties();
        List<String> list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings((Database)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException(exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = SqlplusConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (this.args.size() > 0) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        if (!list.contains("-L")) {
            list.add("-L");
        }
        list.add(this.buildConnectionString((Database)object));
        if (this.outFile != null) {
            list.add("@" + this.outFile.getAbsolutePath());
        }
        object = StringUtil.join(list, " ").replaceAll("(.*) (.*)/\"(.*)\"@(.)", "$1 $2/******@$4");
        Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS command:\n".concat(String.valueOf(object)));
        return list;
    }

    @Override
    protected void processResult(int n2, String string3, String string2, Database database) {
        try {
            List<?> list = this.processResultFromDaticalSpErrorLog(n2, database);
            StringBuilder stringBuilder = new StringBuilder();
            if (list == null || list.isEmpty()) {
                super.processResult(n2, string3, string2, database);
                return;
            }
            stringBuilder.append("Error executing change set '");
            stringBuilder.append(this.changeSet.toString());
            stringBuilder.append("'\n");
            for (String string3 : list) {
                stringBuilder.append(string3.toString().concat("\n"));
            }
            throw new DaticalSpErrorLogException(stringBuilder.toString());
        }
        finally {
            this.dropDaticalSpErrorLog(database);
        }
    }

    @Override
    public void executeCommand(Database database) {
        this.createDaticalSpErrorLogIfNeeded(database);
        this.finalCommandArray = this.createFinalCommandArray(database);
        try {
            super.executeCommand(database);
            if (this.spoolFile != null) {
                this.captureSpoolOutputInLog();
            }
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                return;
            }
        }
        catch (Exception exception) {
            try {
                Exception exception2 = exception;
                if (exception instanceof TimeoutException) {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                    this.processResult(0, null, null, database);
                }
                throw new Exception(exception2);
            }
            catch (Throwable throwable) {
                if (this.spoolFile != null) {
                    this.captureSpoolOutputInLog();
                }
                if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                }
                throw throwable;
            }
        }
    }

    private void dropDaticalSpErrorLog(Database database) {
        String string = database.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(database);
        try {
            jdbcExecutor.execute(new RawSqlStatement(String.format("DROP TABLE %s.%s", string, DATICAL_SPERRORLOG)));
            return;
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to drop table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the DROP TABLE privilege. ", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    private List<?> processResultFromDaticalSpErrorLog(int n2, Database object) {
        String string = object.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        object = null;
        try {
            String string2 = String.format("select CONCAT(CONCAT('Query: ', STATEMENT), CONCAT('>>> Has an error: ', MESSAGE)) as ERROR_MESSAGE from %s.%s WHERE IDENTIFIER='" + this.errorLoggingIdentifier + "'", string, DATICAL_SPERRORLOG);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement(string2), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to query table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the correct privileges. ", string, DATICAL_SPERRORLOG));
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSqlplusProperties() {
        InputStream inputStream;
        String string;
        Object object;
        File file;
        block41: {
            if (StringUtil.trimToEmpty(System.getProperties().getProperty("os.name")).toLowerCase().startsWith("windows")) {
                this.setExecutable("sqlplus.exe");
            } else {
                this.setExecutable("sqlplus");
            }
            file = null;
            Properties properties = new Properties();
            object = SqlplusConfiguration.PATH.getCurrentValue();
            if (object != null) {
                file = new File((String)object);
            }
            object = SqlplusConfiguration.TIMEOUT.getCurrentValue();
            string = SqlplusConfiguration.ARGS.getCurrentValue();
            this.tempName = SqlplusConfiguration.TEMP_NAME.getCurrentValue();
            this.tempPath = SqlplusConfiguration.TEMP_PATH.getCurrentValue();
            this.tempOverwrite = SqlplusConfiguration.TEMP_OVERWRITE.getCurrentValue();
            if (!SqlplusConfiguration.TEMP_KEEP.getCurrentConfiguredValue().wasDefaultValueUsed()) {
                this.keepTempFile = SqlplusConfiguration.TEMP_KEEP.getCurrentValue();
            }
            Object object2 = Scope.getCurrentScope().getResourceAccessor();
            inputStream = null;
            try {
                object2 = object2.openStreams(null, "liquibase.sqlplus.conf");
                Throwable throwable = null;
                try {
                    if (object2 == null || ((InputStreamList)object2).size() == 0) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named 'liquibase.sqlplus.conf' found.");
                    } else {
                        String string2 = ((InputStreamList)object2).getURIs().get(0).getRawPath();
                        Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS configuration file located at '" + string2 + "'.");
                        inputStream = ((InputStreamList)object2).iterator().next();
                        properties.load(inputStream);
                        if (properties.containsKey("liquibase.sqlplus.path")) {
                            file = new File(properties.getProperty("liquibase.sqlplus.path"));
                        }
                        if (properties.containsKey("liquibase.sqlplus.timeout")) {
                            try {
                                object = Integer.parseInt(properties.getProperty("liquibase.sqlplus.timeout"));
                            }
                            catch (Exception exception) {
                                throw new UnexpectedLiquibaseException("Invalid value '" + object + "' for property 'liquibase.sqlplus.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
                            }
                        }
                        if (properties.containsKey("liquibase.sqlplus.keep.temp")) {
                            this.keepTempFile = this.getBooleanFromProperties(properties, "liquibase.sqlplus.keep.temp");
                        }
                        if (properties.containsKey("liquibase.sqlplus.args")) {
                            string = properties.getProperty("liquibase.sqlplus.args");
                        }
                        if (properties.containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
                            this.tempName = properties.getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
                        }
                        if (properties.containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
                            this.tempOverwrite = this.getBooleanFromProperties(properties, SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
                        }
                        if (properties.containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
                            this.tempPath = properties.getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
                        }
                    }
                    if (object2 == null) break block41;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (object2 == null) throw throwable4;
                        if (throwable == null) {
                            ((InputStreamList)object2).close();
                            throw throwable4;
                        }
                        try {
                            ((InputStreamList)object2).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                ((InputStreamList)object2).close();
            }
            catch (IOException iOException) {
                try {
                    throw new UnexpectedLiquibaseException(iOException);
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        if (file != null) {
            if (!file.exists()) {
                throw new UnexpectedLiquibaseException("The executable for the native executor 'sqlplus' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.sqlplus.conf file.\nPlease specify the correct path for the 'sqlplus' executable, or modify your PATH so that it can be located.  Learn more at http://docs.liquibase.com.");
            }
            if (!file.canExecute()) {
                throw new UnexpectedLiquibaseException("The 'sqlplus' executable in the liquibase.sqlplus.conf file at " + file.getAbsolutePath() + " cannot be executed");
            }
            try {
                this.setExecutable(file.getCanonicalPath());
                Scope.getCurrentScope().getLog(this.getClass()).info("Using the 'sqlplus' executable located at:  '" + file.getCanonicalPath() + "'");
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException(iOException);
            }
        }
        if (object != null) {
            this.validateTimeout((Integer)object);
            this.setTimeout(String.valueOf(object));
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a timeout of '" + object + "'");
        }
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim(string, " ");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName == null) return;
        Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file name value of '" + this.tempName + "'");
    }

    private Boolean getBooleanFromProperties(Properties object, String string) {
        if (!((object = ((Properties)object).getProperty(string)) == null || ((String)object).isEmpty() || ((String)(object = ((String)object).toLowerCase())).equals("true") || ((String)object).equals("false"))) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property '" + string + "'. Must be 'true' or 'false'.  Learn more at https://docs.liquibase.com");
        }
        return Boolean.valueOf((String)object);
    }

    private void validateTimeout(Integer n2) {
        if (n2 == null) {
            return;
        }
        if (n2.equals(-1)) {
            return;
        }
        if (n2.equals(0)) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of 0");
        }
        if (n2 <= 0) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of '" + n2 + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSqlStrings(Database object) {
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.info("Creating the SQL run script");
        SqlPlusFileCreator sqlPlusFileCreator = new SqlPlusFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? SqlplusConfiguration.TEMP_OVERWRITE.getDefaultValue().booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? SqlplusConfiguration.TEMP_KEEP.getDefaultValue().booleanValue() : this.keepTempFile.booleanValue());
        try {
            this.spoolFile = sqlPlusFileCreator.generateTemporaryFile(SqlPlusFileCreator$FileTypeEnum.spool);
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        try {
            this.outFile = sqlPlusFileCreator.generateTemporaryFile(SqlPlusFileCreator$FileTypeEnum.sql);
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        boolean bl2 = true;
        Sql[] sqlArray = this.sqlStrings;
        int n2 = this.sqlStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!sqlArray[i2].toSql().toLowerCase().startsWith("whenever")) continue;
            bl2 = false;
            break;
        }
        String string = object.getLiquibaseCatalogName();
        BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
        Throwable throwable = null;
        try {
            bufferedWriter.write("SET ECHO ON\n");
            bufferedWriter.write("SET DEFINE OFF\n");
            bufferedWriter.write(String.format("SET ERRORLOGGING ON TABLE %s.%s TRUNCATE IDENTIFIER '%s' \n", string, DATICAL_SPERRORLOG, this.errorLoggingIdentifier));
            if (bl2) {
                bufferedWriter.write("WHENEVER SQLERROR EXIT FAILURE;\n");
            }
            bufferedWriter.write("SPOOL \"" + this.spoolFile.getAbsolutePath() + "\"\n");
            bufferedWriter.write("SET SQLBLANKLINES ON\n\n");
            boolean bl3 = false;
            Object object2 = this.sqlStrings;
            int n3 = this.sqlStrings.length;
            for (n2 = 0; n2 < n3; ++n2) {
                for (String string2 : object2[n2].toSql().split("\n")) {
                    if (bl3 || !string2.toLowerCase().contains("spool ")) continue;
                    logger.warning("SPOOL statements were detected in your script for change set " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent sqlplus spool output from being included in the Liquibase logs");
                    bl3 = true;
                }
            }
            object2 = this.sqlStrings;
            int n4 = this.sqlStrings.length;
            for (n2 = 0; n2 < n4; ++n2) {
                String string3 = object2[n2].toSql().replace("\r", "");
                bufferedWriter.write(string3 + "\n");
            }
            object2 = this.getEndDelimiter();
            if (object2 != null && ((String)object2).equals("\n/$")) {
                bufferedWriter.write("/\n");
            }
            bufferedWriter.write("EXIT;\n");
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (bufferedWriter == null) throw throwable3;
                if (throwable != null) {
                    try {
                        bufferedWriter.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    bufferedWriter.close();
                }
                throw throwable3;
            }
        }
        bufferedWriter.close();
        return;
    }

    private String getEndDelimiter() {
        String string = null;
        for (Change change : this.changeSet.getChanges()) {
            if (change instanceof AbstractSQLChange && (string = ((AbstractSQLChange)change).getEndDelimiter()) != null) break;
        }
        return string;
    }

    private void createDaticalSpErrorLogIfNeeded(Database object) {
        String string = object.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        try {
            object = String.format("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s' AND TABLE_NAME='%s'", string, DATICAL_SPERRORLOG);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement((String)object), String.class);
        }
        catch (DatabaseException databaseException) {
            throw new DaticalSpErrorLogException(String.format("Can't check if  table: %s exist due to an error", DATICAL_SPERRORLOG), databaseException);
        }
        if (object != null && !object.isEmpty()) {
            try {
                jdbcExecutor.execute(new RawSqlStatement(String.format("DELETE FROM %s.%s", string, DATICAL_SPERRORLOG)));
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to clear rows from table: %s.%s due to an error. Table is locked or the user has insufficient privileges", string, DATICAL_SPERRORLOG));
            }
        }
        try {
            object = String.format("CREATE TABLE %s.%s (username VARCHAR(256), timestamp TIMESTAMP, script VARCHAR(256), identifier VARCHAR(256), message CLOB, statement CLOB)", string, DATICAL_SPERRORLOG);
            jdbcExecutor.execute(new RawSqlStatement((String)object));
            return;
        }
        catch (DatabaseException databaseException) {
            if (databaseException.getMessage().contains("insufficient privileges")) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to create table: %s.%s due to an error. Insufficient privileges", string, DATICAL_SPERRORLOG));
                return;
            }
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to create table: %s.%s due to an error. The table may already exist or you may not have privileges to create it.", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void captureSpoolOutputInLog() {
        Object object;
        block9: {
            object = Scope.getCurrentScope().getLog(this.getClass());
            if (!this.spoolFile.exists()) {
                object.warning("Unable to locate spool output file " + this.spoolFile.getAbsolutePath());
                return;
            }
            object.info("Writing spool output to log");
            BufferedReader bufferedReader = Files.newBufferedReader(this.spoolFile.toPath());
            Throwable throwable = null;
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    object.info(string);
                }
                if (bufferedReader == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (bufferedReader == null) throw throwable3;
                    if (throwable == null) {
                        bufferedReader.close();
                        throw throwable3;
                    }
                    try {
                        bufferedReader.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            bufferedReader.close();
        }
        object.info("\n");
        object.info("Spool output written to log");
    }

    protected String buildConnectionString(Database object) {
        if (object == null) {
            return null;
        }
        Object object2 = (ProJdbcConnection)(object = object.getConnection());
        String string = ((ProJdbcConnection)object2).getUsername();
        if (string == null) {
            string = object.getConnectionUserName();
        }
        string = StringUtil.trimToEmpty(string);
        if (((String)(object2 = StringUtil.trimToEmpty(((ProJdbcConnection)object2).getPassword()))).equals("")) {
            string = "";
        } else {
            object2 = "\"" + (String)object2 + "\"";
        }
        object = object.getURL();
        Matcher matcher = OracleDatabase.PROXY_USER.matcher((CharSequence)object);
        if (matcher.matches()) {
            string = string + "[" + matcher.group(1) + "]";
        }
        object = ((String)object).split("jdbc:oracle:(.*)@")[1];
        return string + "/" + (String)object2 + "@" + (String)object;
    }
}

