/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IRowValueProvider;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.filter.IRowFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowFilterTable
implements ITable,
IRowValueProvider {
    private final ITable originalTable;
    private final List filteredRowIndexes;
    private final Logger logger = LoggerFactory.getLogger(RowFilterTable.class);
    private int currentRowIdx;

    public RowFilterTable(ITable table, IRowFilter rowFilter) throws DataSetException {
        if (table == null || rowFilter == null) {
            throw new IllegalArgumentException("Constructor cannot receive null arguments");
        }
        this.originalTable = table;
        this.filteredRowIndexes = this.setRows(rowFilter);
    }

    private List setRows(IRowFilter rowFilter) throws DataSetException {
        ITableMetaData tableMetadata = this.originalTable.getTableMetaData();
        this.logger.debug("Setting rows for table {}", (Object)tableMetadata.getTableName());
        int fullSize = this.originalTable.getRowCount();
        ArrayList<Integer> filteredRowIndexes = new ArrayList<Integer>();
        int row = 0;
        while (row < fullSize) {
            this.currentRowIdx = row;
            if (rowFilter.accept(this)) {
                this.logger.debug("Adding row {}", (Object)new Integer(row));
                filteredRowIndexes.add(new Integer(row));
            } else {
                this.logger.debug("Discarding row {}", (Object)new Integer(row));
            }
            ++row;
        }
        return filteredRowIndexes;
    }

    @Override
    public ITableMetaData getTableMetaData() {
        this.logger.debug("getTableMetaData() - start");
        return this.originalTable.getTableMetaData();
    }

    @Override
    public int getRowCount() {
        this.logger.debug("getRowCount() - start");
        return this.filteredRowIndexes.size();
    }

    @Override
    public Object getValue(int row, String column) throws DataSetException {
        int max;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        if (row < (max = this.filteredRowIndexes.size())) {
            int realRow = (Integer)this.filteredRowIndexes.get(row);
            Object value = this.originalTable.getValue(realRow, column);
            return value;
        }
        throw new RowOutOfBoundsException("tried to access row " + row + " but rowCount is " + max);
    }

    @Override
    public Object getColumnValue(String columnName) throws DataSetException {
        Object valueOfCol = this.originalTable.getValue(this.currentRowIdx, columnName);
        return valueOfCol;
    }
}

