/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import java.util.Arrays;
import org.dbunit.assertion.DbAssertionFailedError;
import org.dbunit.assertion.DbComparisonFailure;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureFactory;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.ColumnFilterTable;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailureHandler
implements FailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFailureHandler.class);
    private String[] _additionalColumnInfo;
    private FailureFactory failureFactory = new DefaultFailureFactory();

    public DefaultFailureHandler() {
    }

    public DefaultFailureHandler(Column[] additionalColumnInfo) {
        if (additionalColumnInfo != null) {
            this._additionalColumnInfo = Columns.getColumnNames(additionalColumnInfo);
        }
    }

    public DefaultFailureHandler(String[] additionalColumnInfo) {
        this._additionalColumnInfo = additionalColumnInfo;
    }

    public void setFailureFactory(FailureFactory failureFactory) {
        if (failureFactory == null) {
            throw new NullPointerException("The parameter 'failureFactory' must not be null");
        }
        this.failureFactory = failureFactory;
    }

    @Override
    public Error createFailure(String message, String expected, String actual) {
        return this.failureFactory.createFailure(message, expected, actual);
    }

    @Override
    public Error createFailure(String message) {
        return this.failureFactory.createFailure(message);
    }

    @Override
    public String getAdditionalInfo(ITable expectedTable, ITable actualTable, int row, String columnName) {
        return this.buildAdditionalColumnInfo(expectedTable, actualTable, row);
    }

    private String buildAdditionalColumnInfo(ITable expectedTable, ITable actualTable, int rowIndex) {
        if (logger.isDebugEnabled()) {
            logger.debug("buildAdditionalColumnInfo(expectedTable={}, actualTable={}, rowIndex={}, additionalColumnInfo={}) - start", new Object[]{expectedTable, actualTable, new Integer(rowIndex), this._additionalColumnInfo});
        }
        if (this._additionalColumnInfo == null || this._additionalColumnInfo.length <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Additional row info:");
        int j = 0;
        while (j < this._additionalColumnInfo.length) {
            String columnName = this._additionalColumnInfo[j];
            Object expectedKeyValue = this.getColumnValue(expectedTable, rowIndex, columnName);
            Object actualKeyValue = this.getColumnValue(actualTable, rowIndex, columnName);
            sb.append(" ('");
            sb.append(columnName);
            sb.append("': expected=<");
            sb.append(expectedKeyValue);
            sb.append(">, actual=<");
            sb.append(actualKeyValue);
            sb.append(">)");
            ++j;
        }
        return sb.toString();
    }

    protected Object getColumnValue(ITable table, int rowIndex, String columnName) {
        Object value = null;
        try {
            ITable tableForCol = this.getTableForColumn(table, columnName);
            value = tableForCol.getValue(rowIndex, columnName);
        }
        catch (DataSetException e) {
            value = this.makeAdditionalColumnInfoErrorMessage(columnName, e);
        }
        return value;
    }

    protected String makeAdditionalColumnInfoErrorMessage(String columnName, DataSetException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Exception creating more info for column '");
        sb.append(columnName);
        sb.append("': ");
        sb.append(e.getClass().getName());
        sb.append(": ");
        sb.append(e.getMessage());
        String msg = sb.toString();
        logger.warn(msg, (Throwable)e);
        return " (!!!!! " + msg + ")";
    }

    private ITable getTableForColumn(ITable table, String columnName) throws DataSetException {
        ITableMetaData tableMetaData = table.getTableMetaData();
        try {
            tableMetaData.getColumnIndex(columnName);
            return table;
        }
        catch (NoSuchColumnException e) {
            if (table instanceof ColumnFilterTable) {
                ITableMetaData originalMetaData = ((ColumnFilterTable)table).getOriginalMetaData();
                originalMetaData.getColumnIndex(columnName);
                return table;
            }
            throw e;
        }
    }

    @Override
    public void handle(Difference diff) {
        String msg = this.buildMessage(diff);
        Error err = this.createFailure(msg, String.valueOf(diff.getExpectedValue()), String.valueOf(diff.getActualValue()));
        throw err;
    }

    protected String buildMessage(Difference diff) {
        StringBuilder builder = new StringBuilder(200);
        int rowNum = diff.getRowIndex();
        String columnName = diff.getColumnName();
        ITable expectedTable = diff.getExpectedTable();
        ITable actualTable = diff.getActualTable();
        this.addFailMessage(diff, builder);
        String expectedTableName = expectedTable.getTableMetaData().getTableName();
        builder.append("value (table=").append(expectedTableName);
        builder.append(", row=").append(rowNum);
        builder.append(", col=").append(columnName);
        String additionalInfo = this.getAdditionalInfo(expectedTable, actualTable, rowNum, columnName);
        if (additionalInfo != null && !additionalInfo.trim().equals("")) {
            builder.append(", ").append(additionalInfo);
        }
        builder.append(")");
        return builder.toString();
    }

    protected void addFailMessage(Difference diff, StringBuilder builder) {
        String failMessage = diff.getFailMessage();
        boolean isFailMessage = this.isFailMessage(failMessage);
        if (isFailMessage) {
            builder.append(failMessage).append(": ");
        }
    }

    protected boolean isFailMessage(String failMessage) {
        return failMessage != null && !failMessage.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DefaultFailureHandler.class.getName()).append("[");
        sb.append("_additionalColumnInfo=").append(this._additionalColumnInfo == null ? "null" : Arrays.asList(this._additionalColumnInfo).toString());
        sb.append("]");
        return sb.toString();
    }

    public static class DefaultFailureFactory
    implements FailureFactory {
        @Override
        public Error createFailure(String message, String expected, String actual) {
            return new DbComparisonFailure(message, expected, actual);
        }

        @Override
        public Error createFailure(String message) {
            return new DbAssertionFailedError(message);
        }
    }
}

