/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.pools;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.core.server.balancing.pools.AbstractPool;
import org.apache.activemq.artemis.core.server.balancing.pools.DiscoveryService;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetFactory;

public class DiscoveryPool
extends AbstractPool
implements DiscoveryService.Listener {
    private final DiscoveryService discoveryService;

    public DiscoveryPool(TargetFactory targetFactory, ScheduledExecutorService scheduledExecutor, int checkPeriod, DiscoveryService discoveryService) {
        super(targetFactory, scheduledExecutor, checkPeriod);
        this.discoveryService = discoveryService;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.discoveryService.setListener(this);
        this.discoveryService.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.discoveryService != null) {
            this.discoveryService.setListener(null);
            this.discoveryService.stop();
        }
    }

    @Override
    public void entryAdded(DiscoveryService.Entry entry) {
        this.addTarget(entry.getConnector(), entry.getNodeID());
    }

    @Override
    public void entryRemoved(DiscoveryService.Entry entry) {
        this.removeTarget(this.getTarget(entry.getNodeID()));
    }

    @Override
    public void entryUpdated(DiscoveryService.Entry oldEntry, DiscoveryService.Entry newEntry) {
        this.removeTarget(this.getTarget(oldEntry.getNodeID()));
        this.addTarget(newEntry.getConnector(), newEntry.getNodeID());
    }
}

