/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class MonitorInputStream
extends BufferedInputStream {
    private static final int EOF_CHAR = -1;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final AtomicLong atomicCount = new AtomicLong(0L);

    public MonitorInputStream(InputStream in) {
        super(in);
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.finished.get()) {
            return 0;
        }
        return super.available();
    }

    @Override
    public int read() throws IOException {
        if (this.finished.get()) {
            return -1;
        }
        int ch = super.read();
        if (ch != -1) {
            this.atomicCount.incrementAndGet();
            return ch;
        }
        this.close();
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.finished.get()) {
            return -1;
        }
        int nread = super.read(buffer, offset, length);
        if (nread != -1) {
            this.atomicCount.addAndGet(nread);
            return nread;
        }
        this.close();
        return -1;
    }

    @Override
    public void close() throws IOException {
        boolean closed = this.finished.getAndSet(true);
        if (closed) {
            return;
        }
        IOException exc = null;
        try {
            super.close();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.onClose();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected void onClose() throws IOException {
    }

    public long getCount() {
        return this.atomicCount.get();
    }
}

