/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshElevatedUserConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoConnection
extends SshElevatedUserConnection {
    private static Logger logger = LoggerFactory.getLogger(SshSudoConnection.class);

    public SshSudoConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        this.elevatedUsername = (String)options.get("sudoUsername");
        this.elevatedPassword = null;
        this.elevatedPasswordPromptRegex = null;
        this.elevationCommandPrefix = options.get("sudoCommandPrefix", "sudo -u {0}");
        this.quoteCommand = options.getBoolean("sudoQuoteCommand", false);
        this.preserveAttributesOnCopyFromTempFile = options.getBoolean("sudoPreserveAttributesOnCopyFromTempFile", false);
        this.preserveAttributesOnCopyToTempFile = options.getBoolean("sudoPreserveAttributesOnCopyToTempFile", false);
        this.overrideUmask = options.getBoolean("sudoOverrideUmask", true);
        this.copyFromTempFileCommand = options.get("sudoCopyFromTempFileCommand", this.preserveAttributesOnCopyFromTempFile ? "cp -pr {0} {1}" : "cp -r {0} {1}");
        this.copyToTempFileCommand = options.get("sudoCopyToTempFileCommand", this.preserveAttributesOnCopyToTempFile ? "cp -pr {0} {1}" : "cp -r {0} {1}");
        this.overrideUmaskCommand = options.get("sudoOverrideUmaskCommand", "chmod -R go+rX {0}");
        this.tempMkdirCommand = options.get("sudoTempMkdirCommand", "mkdir -m 1777 {0}");
        this.tempMkdirsCommand = options.get("sudoTempMkdirsCommand", "mkdir -p -m 1777 {0}");
    }
}

