/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;

public class NamedExpressionList
implements ItemsList {
    private List<Expression> expressions;
    private List<String> names;

    public NamedExpressionList() {
    }

    public NamedExpressionList(List<Expression> list) {
        this.expressions = list;
    }

    public NamedExpressionList(Expression ... expressionArray) {
        this.expressions = Arrays.asList(expressionArray);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public void setNames(List<String> list) {
        this.names = list;
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i2 = 0; i2 < this.expressions.size(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(" ");
            }
            if (!this.names.get(i2).equals("")) {
                stringBuilder.append(this.names.get(i2)).append(" ").append(this.expressions.get(i2));
                continue;
            }
            stringBuilder.append(this.expressions.get(i2));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public NamedExpressionList withExpressions(List<Expression> list) {
        this.setExpressions(list);
        return this;
    }

    public NamedExpressionList withNames(List<String> list) {
        this.setNames(list);
        return this;
    }

    public NamedExpressionList addExpressions(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withExpressions(list);
    }

    public NamedExpressionList addExpressions(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withExpressions(list);
    }

    public NamedExpressionList addNames(String ... stringArray) {
        List list = Optional.ofNullable(this.getNames()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withNames(list);
    }

    public NamedExpressionList addNames(Collection<String> collection) {
        List list = Optional.ofNullable(this.getNames()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withNames(list);
    }
}

