/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.uuid;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;

public class BasicUUID
implements UUID,
Formatable {
    private long majorId;
    private long timemillis;
    private int sequence;

    public BasicUUID(long l, long l2, int n) {
        this.majorId = l;
        this.timemillis = l2;
        this.sequence = n;
    }

    public BasicUUID(String string) {
        StringReader stringReader = new StringReader(string);
        this.sequence = (int)BasicUUID.readMSB(stringReader);
        long l = BasicUUID.readMSB(stringReader) << 32;
        l += BasicUUID.readMSB(stringReader) << 16;
        this.timemillis = l += BasicUUID.readMSB(stringReader);
        this.majorId = BasicUUID.readMSB(stringReader);
    }

    public BasicUUID() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.majorId);
        objectOutput.writeLong(this.timemillis);
        objectOutput.writeInt(this.sequence);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.majorId = objectInput.readLong();
        this.timemillis = objectInput.readLong();
        this.sequence = objectInput.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 131;
    }

    private static void writeMSB(char[] cArray, int n, long l, int n2) {
        for (int i = n2 - 1; i >= 0; --i) {
            long l2 = (l & 255L << 8 * i) >>> 8 * i;
            int n3 = (int)((l2 & 0xF0L) >> 4);
            cArray[n++] = (char)(n3 < 10 ? n3 + 48 : n3 - 10 + 97);
            n3 = (int)(l2 & 0xFL);
            cArray[n++] = (char)(n3 < 10 ? n3 + 48 : n3 - 10 + 97);
        }
    }

    private static long readMSB(StringReader stringReader) {
        long l = 0L;
        try {
            int n;
            while ((n = stringReader.read()) != -1 && n != 45) {
                l <<= 4;
                int n2 = n <= 57 ? n - 48 : (n <= 70 ? n - 65 + 10 : n - 97 + 10);
                l += (long)n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicUUID)) {
            return false;
        }
        BasicUUID basicUUID = (BasicUUID)object;
        return this.sequence == basicUUID.sequence && this.timemillis == basicUUID.timemillis && this.majorId == basicUUID.majorId;
    }

    public int hashCode() {
        long l = this.majorId ^ this.timemillis;
        return this.sequence ^ (int)(l >> 4);
    }

    public String toString() {
        return this.stringWorkhorse('-');
    }

    @Override
    public String toANSIidentifier() {
        return "U" + this.stringWorkhorse('X');
    }

    public String stringWorkhorse(char c) {
        char[] cArray = new char[36];
        BasicUUID.writeMSB(cArray, 0, this.sequence, 4);
        int n = 8;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        long l = this.timemillis;
        BasicUUID.writeMSB(cArray, n, (l & 0xFFFF00000000L) >>> 32, 2);
        n += 4;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        BasicUUID.writeMSB(cArray, n, (l & 0xFFFF0000L) >>> 16, 2);
        n += 4;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        BasicUUID.writeMSB(cArray, n, l & 0xFFFFL, 2);
        n += 4;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        BasicUUID.writeMSB(cArray, n, this.majorId, 6);
        return new String(cArray, 0, n += 12);
    }

    @Override
    public UUID cloneMe() {
        return new BasicUUID(this.majorId, this.timemillis, this.sequence);
    }
}

