/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Timeout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.Callback;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.utils.MyReentrantLock;

public class HessianProxyFuture
implements Future<Object>,
Constants {
    private boolean _done = false;
    private boolean _canceled = false;
    private HessianRPCReplyMessage _result = null;
    private Lock _lock = new MyReentrantLock();
    private Condition _resultReceived = this._lock.newCondition();
    private Collection<Runnable> _listeners = Collections.synchronizedCollection(new ArrayList());
    private volatile Map<Long, ClientCallback> _callbacks = Collections.synchronizedMap(new HashMap());
    private volatile Timeout _timeout = null;
    private volatile HessianRPCCallMessage _callbackResult;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this._canceled = true;
        return true;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        Object result = null;
        this._lock.lock();
        try {
            while (this._result == null) {
                this._resultReceived.await();
            }
            if (this._result.getFault() != null) {
                throw new ExecutionException(this._result.getFault());
            }
            Object object = this._result.getValue();
            return object;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCallbackResult() throws InterruptedException, ExecutionException {
        this._lock.lock();
        try {
            while (this._callbackResult == null) {
                this._resultReceived.await();
            }
            Throwable exception = null;
            Object result = null;
            Object[] args = this._callbackResult.getArgs();
            if (args == null) {
                Object var4_4 = null;
                return var4_4;
            }
            if (args.length == 0) {
                Object var4_5 = null;
                return var4_5;
            }
            if (args.length >= 1) {
                exception = (Throwable)args[0];
            }
            if (args.length == 2) {
                result = args[1];
            }
            if (exception != null) {
                throw new ExecutionException(exception);
            }
            Object object = result;
            return object;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = null;
        this._lock.lock();
        try {
            if (this._result == null) {
                this._resultReceived.await(timeout, unit);
            }
            if (this._result == null) {
                throw new TimeoutException();
            }
            if (this._result.getFault() != null) {
                throw new ExecutionException(this._result.getFault());
            }
            Object object = this._result.getValue();
            return object;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return this._canceled;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    protected synchronized void set(HessianRPCReplyMessage message) {
        this.set(message, null);
    }

    public synchronized void set(HessianRPCReplyMessage message, ChannelHandlerContext ctx) {
        this._lock.lock();
        if (this._timeout != null) {
            this._timeout.cancel();
        }
        try {
            if (message instanceof CallbackReplyMessage) {
                this.handleCallbackReply((CallbackReplyMessage)message, ctx);
            } else {
                this._done = true;
                this._result = message;
                this._resultReceived.signal();
                this.callListners();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public synchronized void setCallbackResult(HessianRPCCallMessage result) {
        this._lock.lock();
        if (this._timeout != null) {
            this._timeout.cancel();
        }
        try {
            this._done = true;
            this._callbackResult = result;
            this._resultReceived.signal();
            this.callListners();
        }
        finally {
            this._lock.unlock();
        }
    }

    private void handleCallbackReply(CallbackReplyMessage message, ChannelHandlerContext ctx) {
        Long callbackId = message.getCallbackId();
        if (callbackId == null) {
            return;
        }
        ClientCallback callback = this._callbacks.get(callbackId);
        if (callback == null) {
            System.out.println("no callback found for " + callbackId);
            return;
        }
        callback.invoke(message, ctx);
        if (message.isDone()) {
            this._callbacks.remove(callbackId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListners() {
        Collection<Runnable> collection = this._listeners;
        synchronized (collection) {
            for (Runnable listener : this._listeners) {
                listener.run();
            }
        }
    }

    public void addListener(Runnable listener) {
        this._lock.lock();
        try {
            if (this.isDone()) {
                listener.run();
            } else {
                this._listeners.add(listener);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void removeListener(Runnable listener) {
        this._listeners.remove(listener);
    }

    public void handleCallbacks(Object[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Callback)) continue;
            ClientCallback c = new ClientCallback((Callback)args[i]);
            this._callbacks.put(c.getId(), c);
            args[i] = c;
        }
    }

    public boolean hasCallbacks() {
        return this._callbacks.size() != 0;
    }

    public void setTimeout(Timeout timeout) {
        this._timeout = timeout;
    }

    public void timedOut() {
        this._lock.lock();
        this._timeout = null;
        try {
            this.set(new HessianRPCReplyMessage(null, new TimeoutException(), null));
        }
        finally {
            this._lock.unlock();
        }
    }
}

