/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.replay;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.jboss.logging.Logger;

public class ReplayManager {
    private static final Logger logger = Logger.getLogger(ReplayManager.class);
    private final ActiveMQServer server;
    private JournalImpl journal;
    private final File retentionFolder;
    private final SimpleDateFormat dateFormat = ReplayManager.newRetentionSimpleDateFormat();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public static SimpleDateFormat newRetentionSimpleDateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public ReplayManager(ActiveMQServer server) {
        this.server = server;
        this.retentionFolder = server.getConfiguration().getJournalRetentionLocation();
    }

    public void replay(Date start, Date end, String sourceAddress, String targetAddress, String filter) throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.actualReplay(start, end, sourceAddress, targetAddress, filter);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
                throw e;
            }
            finally {
                this.running.set(false);
            }
        } else {
            throw new RuntimeException("Replay manager is currently busy with another operation");
        }
    }

    private void actualReplay(Date start, Date end, String sourceAddress, String targetAddressParameter, String filterStr) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Replay::" + sourceAddress));
        }
        if (sourceAddress == null) {
            throw new NullPointerException("sourceAddress");
        }
        if (targetAddressParameter == null || targetAddressParameter.trim().isEmpty()) {
            targetAddressParameter = sourceAddress;
        }
        String targetAddress = targetAddressParameter;
        if (this.journal == null) {
            this.journal = (JournalImpl)this.server.getStorageManager().getMessageJournal();
        }
        final Filter filter = filterStr != null ? FilterImpl.createFilter(filterStr) : null;
        this.journal.forceBackup(1, TimeUnit.MINUTES);
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(this.retentionFolder, null, 1);
        JournalImpl messagesJournal = new JournalImpl(this.server.getConfiguration().getJournalFileSize(), this.server.getConfiguration().getJournalMinFiles(), this.server.getConfiguration().getJournalPoolFiles(), 0, 0, (SequentialFileFactory)messagesFF, "activemq-data", "amq", 1);
        List files = messagesJournal.orderFiles();
        final RoutingContextImpl context = new RoutingContextImpl(null);
        final HashMap largeMessageLocations = new HashMap();
        for (final JournalFile file : files) {
            if (start != null || end != null) {
                long fileEpochTime = this.journal.getDatePortionMillis(file.getFile().getFileName());
                if (logger.isDebugEnabled()) {
                    String datePortion = this.journal.getDatePortion(file.getFile().getFileName());
                    logger.debug((Object)("Evaluating replay for file " + file.getFile().getFileName() + ", datePortion=" + datePortion + "\n\tInterval evaluated: start(" + start + ") --- file(" + new Date(fileEpochTime) + ") --- end(" + end + ")\n\tepoch times: start(" + start.getTime() + ") --- file(" + fileEpochTime + ") + end(" + end.getTime() + ")"));
                }
                if (start != null && fileEpochTime < start.getTime()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("File " + file.getFile().getFileName() + " being skipped on start comparison"));
                    continue;
                }
                if (end != null && fileEpochTime > end.getTime()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("File " + file.getFile().getFileName() + " being skipped on end comparison"));
                    continue;
                }
            }
            JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback((SequentialFileFactory)messagesFF, sourceAddress, targetAddress){
                final /* synthetic */ SequentialFileFactory val$messagesFF;
                final /* synthetic */ String val$sourceAddress;
                final /* synthetic */ String val$targetAddress;
                {
                    this.val$messagesFF = sequentialFileFactory;
                    this.val$sourceAddress = string;
                    this.val$targetAddress = string2;
                }

                public void onReadEventRecord(RecordInfo info) throws Exception {
                    switch (info.getUserRecordType()) {
                        case 49: {
                            LinkedHashSet<JournalFile> files = (LinkedHashSet<JournalFile>)largeMessageLocations.get(info.id);
                            if (files == null) {
                                files = new LinkedHashSet<JournalFile>();
                                largeMessageLocations.put(info.id, files);
                            }
                            files.add(file);
                            break;
                        }
                        default: {
                            this.onReadAddRecord(info);
                        }
                    }
                }

                public void onReadAddRecord(RecordInfo info) throws Exception {
                    if (info.getUserRecordType() == 30) {
                        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])info.data);
                        LargeServerMessageImpl message = new LargeServerMessageImpl(ReplayManager.this.server.getStorageManager());
                        LargeMessagePersister.getInstance().decode(buffer, message, null);
                        ReplayManager.this.route(filter, context, this.val$messagesFF, message.toMessage(), this.val$sourceAddress, this.val$targetAddress, largeMessageLocations);
                    } else if (info.getUserRecordType() == 45) {
                        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])info.data);
                        Message message = MessagePersister.getInstance().decode(buffer, null, null, ReplayManager.this.server.getStorageManager());
                        ReplayManager.this.route(filter, context, this.val$messagesFF, message, this.val$sourceAddress, this.val$targetAddress, largeMessageLocations);
                    }
                }

                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    this.onReadAddRecord(info);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecord(info);
                }

                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadUpdateRecord(info);
                }
            }, null, (boolean)false, null);
        }
    }

    private boolean messageMatch(Filter filter, Message message, String sourceAddress, String targetAddress) {
        if (message.getAddress() != null && message.getAddress().equals(sourceAddress)) {
            if (filter != null && !filter.match(message)) {
                return false;
            }
            if (targetAddress != null && !targetAddress.equals(sourceAddress)) {
                message.setAddress(targetAddress);
                message.reencode();
            }
            return true;
        }
        return false;
    }

    private void route(Filter filter, RoutingContext context, SequentialFileFactory messagesFF, Message message, String sourceAddress, String targetAddress, HashMap<Long, LinkedHashSet<JournalFile>> filesMap) throws Exception {
        if (this.messageMatch(filter, message, sourceAddress, targetAddress)) {
            long originalMessageID = message.getMessageID();
            message.setMessageID(this.server.getStorageManager().generateID());
            if (message.isLargeMessage()) {
                this.readLargeMessageBody(messagesFF, message, filesMap, originalMessageID);
            }
            if (targetAddress != null && !sourceAddress.equals(targetAddress)) {
                message.setAddress(targetAddress);
                message.reencode();
            }
            this.server.getPostOffice().route(message, context, false, false, null);
            context.clear();
        } else if (message.isLargeMessage()) {
            filesMap.remove(message.getMessageID());
        }
    }

    private void readLargeMessageBody(SequentialFileFactory messagesFF, Message message, HashMap<Long, LinkedHashSet<JournalFile>> filesMap, final long originalMessageID) throws Exception {
        final long newMessageID = message.getMessageID();
        final SequentialFile largeMessageFile = this.server.getStorageManager().createFileForLargeMessage(newMessageID, true);
        largeMessageFile.open();
        LinkedHashSet<JournalFile> files = filesMap.get(originalMessageID);
        if (files != null) {
            for (JournalFile file : files) {
                JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

                    public void onReadEventRecord(RecordInfo info) throws Exception {
                        if (info.userRecordType == 49 && info.id == originalMessageID) {
                            ReplayManager.this.server.getStorageManager().addBytesToLargeMessage(largeMessageFile, newMessageID, info.data);
                        }
                    }
                });
            }
        }
        largeMessageFile.close();
    }
}

