/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecurityServiceLocator {
    private static final AtomicReference<PermissionEnforcer> permissionEnforcer = new AtomicReference();
    private static final AtomicReference<ViewAsData> viewAsData = new AtomicReference();
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceLocator.class);

    @Autowired
    public SecurityServiceLocator(PermissionEnforcer enforcer, ViewAsData viewAsData) {
        permissionEnforcer.set(enforcer);
        SecurityServiceLocator.viewAsData.set(viewAsData);
    }

    public static PermissionEnforcer getPermissionEnforcer() {
        return permissionEnforcer.get();
    }

    public static ViewAsData getViewAsData() {
        try {
            viewAsData.get().getUser();
            return viewAsData.get();
        }
        catch (IllegalStateException | NullPointerException | BeanCreationException e) {
            logger.debug("Session bean 'viewAsData' not accessible");
            return null;
        }
    }
}

