/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCopyCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksCustomizeCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "customize"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        List<DynamicRuleParameter> list = commandResultsBuilder.getCommandScope();
        String string2 = ((CommandScope)((Object)list)).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        list = ((CommandScope)((Object)list)).getConfiguredValue(CHECK_NAME_ARG).getValue();
        CheckSettingsConfigHelper checkSettingsConfigHelper = new CheckSettingsConfigHelper(string2);
        List<AbstractLiquibaseRule> list2 = ChecksCustomizeCommandStep.listAllRules();
        CheckSettingsConfig checkSettingsConfig = checkSettingsConfigHelper.read(list2);
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        DynamicRule dynamicRule = checkSettingsConfig.getDynamicConfigurableRuleByShortName((String)((Object)list), "does not have customization options");
        AbstractLiquibaseRule abstractLiquibaseRule = ChecksCustomizeCommandStep.findConfigurableParentRule(dynamicRule, list2, (String)((Object)list), "does not have customization options");
        if (!abstractLiquibaseRule.hasDefaultParameterValues() && !dynamicRule.isCopy()) {
            Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "This check can not be customized directly because one or more fields does not have a default value.  Creating a copy of this check and initiating the customization workflow.");
            ChecksCopyCommandStep.doCopy(checkSettingsConfig, list, list2, string2, commandResultsBuilder, checkSettingsConfigHelper);
        } else {
            list = ChecksCustomizeCommandStep.promptForParameters(abstractLiquibaseRule.getParameters(), dynamicRule);
            if (!dynamicRule.isEnabled() && (list2 = Scope.getCurrentScope().getUI().prompt("This check is disabled.  Enable it? (Y/n)", null, (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class)) != null && ((String)((Object)list2)).equalsIgnoreCase("y")) {
                dynamicRule.setEnabled(true);
            }
            dynamicRule.getParameters().clear();
            dynamicRule.getParameters().addAll(list);
            checkSettingsConfigHelper.write(checkSettingsConfig);
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public static List<DynamicRuleParameter> promptForParameters(List<DynamicRuleParameterEnum> object, DynamicRule dynamicRule) {
        ArrayList<DynamicRuleParameter> arrayList = new ArrayList<DynamicRuleParameter>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (DynamicRuleParameterEnum)((Object)object.next());
            Optional<DynamicRuleParameter> optional = dynamicRule.getParameters().stream().filter(arg_0 -> ChecksCustomizeCommandStep.lambda$promptForParameters$1((DynamicRuleParameterEnum)((Object)object2), arg_0)).findFirst();
            Object object3 = object2.defaultValue;
            if (object3 != null) {
                object2.interactiveCommandLineValueGetter.setDefaultValue(object3);
                object2.interactiveCommandLineValueGetter.setShouldAllowEmptyValues(true);
            }
            if ((optional = !optional.isPresent() ? null : optional.get().getValue()) != null) {
                object2.interactiveCommandLineValueGetter.setCurrentValue(optional);
                object2.interactiveCommandLineValueGetter.setShouldAllowEmptyValues(true);
            }
            optional = object2.interactiveCommandLineValueGetter.prompt((DynamicRuleParameterEnum)((Object)object2));
            object2 = new DynamicRuleParameter((DynamicRuleParameterEnum)((Object)object2), optional);
            arrayList.add((DynamicRuleParameter)object2);
        }
        return arrayList;
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("CLI-guided configuration of the named check");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private static /* synthetic */ boolean lambda$promptForParameters$1(DynamicRuleParameterEnum dynamicRuleParameterEnum, DynamicRuleParameter dynamicRuleParameter) {
        return dynamicRuleParameter.getParameter() == dynamicRuleParameterEnum;
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to configure").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

