/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.filter.IColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Columns {
    private static final Logger logger = LoggerFactory.getLogger(Columns.class);
    private static final ColumnComparator COLUMN_COMPARATOR = new ColumnComparator();
    private static final Column[] EMPTY_COLUMNS = new Column[0];

    private Columns() {
    }

    public static Column[] getColumns(String[] columnNames, Column[] columns) {
        if (logger.isDebugEnabled()) {
            logger.debug("getColumns(columnNames={}, columns={}) - start", new Object[]{columnNames, columns});
        }
        if (columnNames == null || columnNames.length == 0) {
            return EMPTY_COLUMNS;
        }
        ArrayList<Column> resultList = new ArrayList<Column>();
        int i = 0;
        while (i < columnNames.length) {
            Column column = Columns.getColumn(columnNames[i], columns);
            if (column != null) {
                resultList.add(column);
            }
            ++i;
        }
        return resultList.toArray(new Column[0]);
    }

    public static Column[] findColumnsByName(String[] columnNames, ITableMetaData tableMetaData) throws NoSuchColumnException, DataSetException {
        logger.debug("findColumnsByName(columnNames={}, tableMetaData={}) - start", (Object)columnNames, (Object)tableMetaData);
        Column[] resultColumns = new Column[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            String sortColumn = columnNames[i];
            int colIndex = tableMetaData.getColumnIndex(sortColumn);
            resultColumns[i] = tableMetaData.getColumns()[colIndex];
            ++i;
        }
        return resultColumns;
    }

    public static Column[] findColumnsByName(Column[] columns, ITableMetaData tableMetaData) throws NoSuchColumnException, DataSetException {
        logger.debug("findColumnsByName(columns={}, tableMetaData={}) - start", (Object)columns, (Object)tableMetaData);
        Column[] resultColumns = new Column[columns.length];
        int i = 0;
        while (i < columns.length) {
            Column sortColumn = columns[i];
            int colIndex = tableMetaData.getColumnIndex(sortColumn.getColumnName());
            resultColumns[i] = tableMetaData.getColumns()[colIndex];
            ++i;
        }
        return resultColumns;
    }

    public static Column getColumn(String columnName, Column[] columns) {
        logger.debug("getColumn(columnName={}, columns={}) - start", (Object)columnName, (Object)columns);
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (columnName.equalsIgnoreCase(columns[i].getColumnName())) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public static Column getColumnValidated(String columnName, Column[] columns, String tableName) throws NoSuchColumnException {
        Column column;
        if (logger.isDebugEnabled()) {
            logger.debug("getColumn(columnName={}, columns={}, tableName={}) - start", new Object[]{columnName, columns, tableName});
        }
        if ((column = Columns.getColumn(columnName, columns)) == null) {
            throw new NoSuchColumnException(tableName, columnName);
        }
        return column;
    }

    public static Column[] getColumns(String tableName, Column[] columns, IColumnFilter columnFilter) {
        if (logger.isDebugEnabled()) {
            logger.debug("getColumns(tableName={}, columns={}, columnFilter={}) - start", new Object[]{tableName, columns, columnFilter});
        }
        ArrayList<Column> resultList = new ArrayList<Column>();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (columnFilter.accept(tableName, column)) {
                resultList.add(column);
            }
            ++i;
        }
        return resultList.toArray(new Column[0]);
    }

    public static Column[] getSortedColumns(ITableMetaData metaData) throws DataSetException {
        logger.debug("getSortedColumns(metaData={}) - start", (Object)metaData);
        Column[] columns = metaData.getColumns();
        Column[] sortColumns = new Column[columns.length];
        System.arraycopy(columns, 0, sortColumns, 0, columns.length);
        Arrays.sort(sortColumns, COLUMN_COMPARATOR);
        return sortColumns;
    }

    public static String[] getColumnNames(Column[] columns) {
        String[] result = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            result[i] = columns[i].getColumnName();
            ++i;
        }
        return result;
    }

    public static String getColumnNamesAsString(Column[] columns) {
        logger.debug("getColumnNamesAsString(columns={}) - start", (Object[])columns);
        String[] names = new String[columns.length];
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            names[i] = column.getColumnName();
            ++i;
        }
        return Arrays.asList(names).toString();
    }

    public static Column[] mergeColumnsByName(Column[] referenceColumns, Column[] columnsToMerge) {
        logger.debug("mergeColumnsByName(referenceColumns={}, columnsToMerge={}) - start", (Object)referenceColumns, (Object)columnsToMerge);
        ArrayList<Column> resultList = new ArrayList<Column>(Arrays.asList(referenceColumns));
        ArrayList<Column> columnsToMergeNotInRefList = new ArrayList<Column>(Arrays.asList(columnsToMerge));
        int i = 0;
        while (i < referenceColumns.length) {
            Column refColumn = referenceColumns[i];
            int k = 0;
            while (k < columnsToMerge.length) {
                Column columnToMerge = columnsToMerge[k];
                if (columnToMerge.getColumnName().equals(refColumn.getColumnName())) {
                    columnsToMergeNotInRefList.remove(columnToMerge);
                    break;
                }
                ++k;
            }
            ++i;
        }
        resultList.addAll(columnsToMergeNotInRefList);
        return resultList.toArray(new Column[0]);
    }

    public static ColumnDiff getColumnDiff(ITableMetaData expectedMetaData, ITableMetaData actualMetaData) throws DataSetException {
        return new ColumnDiff(expectedMetaData, actualMetaData);
    }

    private static class ColumnComparator
    implements Comparator {
        private static final Logger logger = LoggerFactory.getLogger(ColumnComparator.class);

        private ColumnComparator() {
        }

        public int compare(Object o1, Object o2) {
            logger.debug("compare(o1={}, o2={}) - start", o1, o2);
            Column column1 = (Column)o1;
            Column column2 = (Column)o2;
            String columnName1 = column1.getColumnName();
            String columnName2 = column2.getColumnName();
            return columnName1.compareToIgnoreCase(columnName2);
        }
    }

    public static class ColumnDiff {
        private static final Logger logger = LoggerFactory.getLogger(ColumnDiff.class);
        private static final String NO_DIFFERENCE = "no difference found";
        private Column[] expected;
        private Column[] actual;
        private ITableMetaData expectedMetaData;
        private ITableMetaData actualMetaData;

        public ColumnDiff(ITableMetaData expectedMetaData, ITableMetaData actualMetaData) throws DataSetException {
            if (expectedMetaData == null) {
                throw new NullPointerException("The parameter 'expectedMetaData' must not be null");
            }
            if (actualMetaData == null) {
                throw new NullPointerException("The parameter 'actualMetaData' must not be null");
            }
            this.expectedMetaData = expectedMetaData;
            this.actualMetaData = actualMetaData;
            Column[] allExpectedCols = expectedMetaData.getColumns();
            Column[] allActualCols = actualMetaData.getColumns();
            this.actual = this.findMissingColumnsIn(expectedMetaData, allActualCols);
            this.expected = this.findMissingColumnsIn(actualMetaData, allExpectedCols);
        }

        private Column[] findMissingColumnsIn(ITableMetaData metaDataToCheck, Column[] columnsToSearch) throws DataSetException {
            logger.debug("findMissingColumnsIn(metaDataToCheck={}, columnsToSearch={})", (Object)metaDataToCheck, (Object)columnsToSearch);
            ArrayList<Column> columnsNotFound = new ArrayList<Column>();
            int i = 0;
            while (i < columnsToSearch.length) {
                try {
                    metaDataToCheck.getColumnIndex(columnsToSearch[i].getColumnName());
                }
                catch (NoSuchColumnException e) {
                    columnsNotFound.add(columnsToSearch[i]);
                }
                ++i;
            }
            Column[] result = columnsNotFound.toArray(new Column[0]);
            return result;
        }

        public boolean hasDifference() {
            return this.expected.length > 0 || this.actual.length > 0;
        }

        public Column[] getExpected() {
            return this.expected;
        }

        public Column[] getActual() {
            return this.actual;
        }

        public String getExpectedAsString() {
            return Columns.getColumnNamesAsString(this.expected);
        }

        public String getActualAsString() {
            return Columns.getColumnNamesAsString(this.actual);
        }

        public String getMessage() throws DataSetException {
            logger.debug("getMessage() - start");
            if (!this.hasDifference()) {
                return NO_DIFFERENCE;
            }
            Column[] allExpectedCols = this.expectedMetaData.getColumns();
            Column[] allActualCols = this.actualMetaData.getColumns();
            String expectedTableName = this.expectedMetaData.getTableName();
            String message = allExpectedCols.length != allActualCols.length ? "column count (table=" + expectedTableName + ", " + "expectedColCount=" + allExpectedCols.length + ", actualColCount=" + allActualCols.length + ")" : "column mismatch (table=" + expectedTableName + ")";
            return message;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName()).append("[");
            sb.append("expected=").append(Arrays.asList(this.expected).toString());
            sb.append(", actual=").append(Arrays.asList(this.actual).toString());
            sb.append("]");
            return sb.toString();
        }
    }
}

