/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class UnexpectedCheckConstraintChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (CheckConstraint.class.isAssignableFrom(clazz)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class};
    }

    @Override
    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        if (((CheckConstraint)(databaseObject = (CheckConstraint)databaseObject)).getTable() == null) {
            return null;
        }
        object = new DropCheckConstraintChange();
        ((DropCheckConstraintChange)object).setTableName(((CheckConstraint)databaseObject).getTable().getName());
        if (diffOutputControl.getIncludeCatalog()) {
            ((DropCheckConstraintChange)object).setCatalogName(((CheckConstraint)databaseObject).getTable().getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((DropCheckConstraintChange)object).setSchemaName(((CheckConstraint)databaseObject).getTable().getSchema().getName());
        }
        ((DropCheckConstraintChange)object).setConstraintName(((CheckConstraint)databaseObject).getName());
        return new Change[]{object};
    }
}

