/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.client.BootstrapProvider;

public class ReconnectHandler
extends ChannelInboundHandlerAdapter {
    private Timer _timer;
    private long RECONNECT_DELAY = 10000L;
    private long MAX_RECONNECT_DELAY = 10000L;
    private BootstrapProvider _bootstrap;
    private volatile boolean _stop = false;
    private volatile Timeout _timeout;
    private volatile int _retryCounter = 0;

    public ReconnectHandler(BootstrapProvider bootstrap, long reconnectDelay, Timer timer) {
        this.RECONNECT_DELAY = reconnectDelay;
        this._bootstrap = bootstrap;
        this._timer = timer;
    }

    public ReconnectHandler(BootstrapProvider bootstrap) {
        this._bootstrap = bootstrap;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        this.scheduleReconnect();
    }

    private synchronized void scheduleReconnect() {
        if (this._stop) {
            return;
        }
        if (this._timeout != null) {
            return;
        }
        Constants.ahessianLogger.warn("channel closed wait to reconnect ...");
        ++this._retryCounter;
        long retryIntervall = Math.min(this.RECONNECT_DELAY * (long)this._retryCounter, this.MAX_RECONNECT_DELAY);
        this._timeout = this._timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                ReconnectHandler.this._timeout = null;
                ReconnectHandler.this.connect(ReconnectHandler.this._bootstrap.getBootstrap());
            }
        }, retryIntervall, TimeUnit.MILLISECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        Throwable cause = e;
        cause.printStackTrace();
        if (cause instanceof ConnectException) {
            Constants.ahessianLogger.warn("conection lost");
            this.scheduleReconnect();
        }
        try {
            ctx.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this._stop = true;
        Timeout timeout = this._timeout;
        this._timeout = null;
        timeout.cancel();
    }

    protected void connect(AbstractBootstrap bootstrap) {
        Channel channel = null;
        Constants.ahessianLogger.warn("reconnecting...");
        while (channel == null && !this._stop) {
            try {
                channel = ((Bootstrap)bootstrap).connect().sync().channel();
            }
            catch (Exception ex) {
                if (!(ex instanceof ConnectException)) continue;
                System.out.println(ex);
                try {
                    Thread.sleep(this.RECONNECT_DELAY);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

