/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.cassandra.CassandraDriverHealthIndicator;
import org.springframework.boot.actuate.cassandra.CassandraDriverReactiveHealthIndicator;
import org.springframework.boot.actuate.cassandra.CassandraHealthIndicator;
import org.springframework.boot.actuate.cassandra.CassandraReactiveHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;

class CassandraHealthContributorConfigurations {
    CassandraHealthContributorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveCassandraOperations.class})
    @ConditionalOnBean(value={ReactiveCassandraOperations.class})
    @Deprecated
    static class CassandraReactiveOperationsConfiguration
    extends CompositeReactiveHealthContributorConfiguration<CassandraReactiveHealthIndicator, ReactiveCassandraOperations> {
        CassandraReactiveOperationsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        ReactiveHealthContributor cassandraHealthContributor(Map<String, ReactiveCassandraOperations> reactiveCassandraOperations) {
            return (ReactiveHealthContributor)this.createContributor(reactiveCassandraOperations);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CqlSession.class})
    static class CassandraReactiveDriverConfiguration
    extends CompositeReactiveHealthContributorConfiguration<CassandraDriverReactiveHealthIndicator, CqlSession> {
        CassandraReactiveDriverConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        ReactiveHealthContributor cassandraHealthContributor(Map<String, CqlSession> sessions) {
            return (ReactiveHealthContributor)this.createContributor(sessions);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CassandraOperations.class})
    @ConditionalOnBean(value={CassandraOperations.class})
    @Deprecated
    static class CassandraOperationsConfiguration
    extends CompositeHealthContributorConfiguration<CassandraHealthIndicator, CassandraOperations> {
        CassandraOperationsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        HealthContributor cassandraHealthContributor(Map<String, CassandraOperations> cassandraOperations) {
            return (HealthContributor)this.createContributor(cassandraOperations);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CqlSession.class})
    static class CassandraDriverConfiguration
    extends CompositeHealthContributorConfiguration<CassandraDriverHealthIndicator, CqlSession> {
        CassandraDriverConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        HealthContributor cassandraHealthContributor(Map<String, CqlSession> sessions) {
            return (HealthContributor)this.createContributor(sessions);
        }
    }
}

