/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.jetty;

import com.tqdev.metrics.core.MetricRegistry;
import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class InstrumentedHandler
extends HandlerWrapper {
    private final MetricRegistry registry;
    private AsyncListener listener = new AsyncListener(){
        private long startTime;

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            this.startTime = InstrumentedHandler.this.registry.getNanos();
            event.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            HttpServletRequest request = (HttpServletRequest)state.getRequest();
            HttpServletResponse response = (HttpServletResponse)state.getResponse();
            InstrumentedHandler.this.updateResponses(request, response, this.startTime);
        }
    };

    public InstrumentedHandler(MetricRegistry registry) {
        this.registry = registry;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (int responseStatus = 1; responseStatus <= 5; ++responseStatus) {
            this.registry.set("jetty.Response.Invocations", responseStatus + "xx-responses", 0L);
            this.registry.set("jetty.Response.Durations", responseStatus + "xx-responses", 0L);
        }
        this.registry.set("jetty.Response.Invocations", "other-responses", 0L);
        this.registry.set("jetty.Response.Durations", "other-responses", 0L);
        for (HttpMethod method : HttpMethod.values()) {
            String name = method.asString().toLowerCase();
            this.registry.set("jetty.Request.Invocations", name + "-requests", 0L);
            this.registry.set("jetty.Request.Durations", name + "-requests", 0L);
        }
        this.registry.set("jetty.Request.Invocations", "other-requests", 0L);
        this.registry.set("jetty.Request.Durations", "other-requests", 0L);
        this.registry.set("jetty.Aggregated.Invocations", "requests", 0L);
        this.registry.set("jetty.Aggregated.Durations", "requests", 0L);
        this.registry.set("jetty.Thread.Gauges", "threads", () -> this.getServer().getThreadPool().getThreads());
        this.registry.set("jetty.Thread.Gauges", "idle-threads", () -> this.getServer().getThreadPool().getIdleThreads());
        if (this.getServer().getThreadPool() instanceof QueuedThreadPool) {
            this.registry.set("jetty.Thread.Gauges", "busy-threads", () -> ((QueuedThreadPool)this.getServer().getThreadPool()).getBusyThreads());
            this.registry.set("jetty.Thread.Gauges", "min-threads", () -> ((QueuedThreadPool)this.getServer().getThreadPool()).getMinThreads());
            this.registry.set("jetty.Thread.Gauges", "max-threads", () -> ((QueuedThreadPool)this.getServer().getThreadPool()).getMaxThreads());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        if (!this.registry.isEnabled()) {
            super.handle(path, request, httpRequest, httpResponse);
            return;
        }
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            state.addListener(this.listener);
        }
        long startTime = this.registry.getNanos();
        try {
            super.handle(path, request, httpRequest, httpResponse);
        }
        finally {
            if (!state.isSuspended() && state.isInitial()) {
                this.updateResponses(httpRequest, httpResponse, startTime);
            }
        }
    }

    private String getMethodGroup(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return "other";
        }
        return m.asString().toLowerCase();
    }

    private String getStatusGroup(int status) {
        int responseStatus = status / 100;
        if (responseStatus < 1 || responseStatus > 5) {
            return "other";
        }
        return responseStatus + "xx";
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long startTime) {
        long duration = this.registry.getNanos() - startTime;
        this.registry.increment("jetty.Aggregated.Invocations", "requests");
        this.registry.add("jetty.Aggregated.Durations", "requests", duration);
        String methodGroup = this.getMethodGroup(request.getMethod());
        this.registry.increment("jetty.Request.Invocations", methodGroup + "-requests");
        this.registry.add("jetty.Request.Durations", methodGroup + "-requests", duration);
        String statusGroup = this.getStatusGroup(response.getStatus());
        this.registry.increment("jetty.Response.Invocations", statusGroup + "-responses");
        this.registry.add("jetty.Response.Durations", statusGroup + "-responses", duration);
    }
}

