/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.StringUtils;

public final class MapOAuth2AccessTokenResponseConverter
implements Converter<Map<String, String>, OAuth2AccessTokenResponse> {
    private static final Set<String> TOKEN_RESPONSE_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("access_token", "expires_in", "refresh_token", "scope", "token_type"));

    public OAuth2AccessTokenResponse convert(Map<String, String> tokenResponseParameters) {
        String accessToken = tokenResponseParameters.get("access_token");
        OAuth2AccessToken.TokenType accessTokenType = this.getAccessTokenType(tokenResponseParameters);
        long expiresIn = this.getExpiresIn(tokenResponseParameters);
        Set<String> scopes = this.getScopes(tokenResponseParameters);
        String refreshToken = tokenResponseParameters.get("refresh_token");
        LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : tokenResponseParameters.entrySet()) {
            if (TOKEN_RESPONSE_PARAMETER_NAMES.contains(entry.getKey())) continue;
            additionalParameters.put(entry.getKey(), entry.getValue());
        }
        return OAuth2AccessTokenResponse.withToken(accessToken).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
    }

    private OAuth2AccessToken.TokenType getAccessTokenType(Map<String, String> tokenResponseParameters) {
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(tokenResponseParameters.get("token_type"))) {
            return OAuth2AccessToken.TokenType.BEARER;
        }
        return null;
    }

    private long getExpiresIn(Map<String, String> tokenResponseParameters) {
        if (tokenResponseParameters.containsKey("expires_in")) {
            try {
                return Long.parseLong(tokenResponseParameters.get("expires_in"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private Set<String> getScopes(Map<String, String> tokenResponseParameters) {
        if (tokenResponseParameters.containsKey("scope")) {
            String scope = tokenResponseParameters.get("scope");
            return new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        return Collections.emptySet();
    }
}

